<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Creer ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Creer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreerFamille
     * Meta information extracted from the WSDL
     * - documentation: Crée une famille à rubriques prédéfinies pour les genre 'AGenres' de libellé 'ALibelle' dans la base
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aLibelle
     * @param \Hp_\StructType\Hp_THpSvcWTableauGenresFamille $aGenres
     * @return THpSvcWCleFamille|bool
     */
    public function CreerFamille($aLibelle, \Hp_\StructType\Hp_THpSvcWTableauGenresFamille $aGenres)
    {
        try {
            $this->setResult($this->getSoapClient()->CreerFamille($aLibelle, $aGenres));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreerRubriqueDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Crée une rubrique de la famille 'AFamille' de libellé 'ALibelle' dans la base. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aLibelle
     * @return THpSvcWCleRubrique|bool
     */
    public function CreerRubriqueDeFamille($aFamille, $aLibelle)
    {
        try {
            $this->setResult($this->getSoapClient()->CreerRubriqueDeFamille($aFamille, $aLibelle));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreerFamilleARubriquesLibres
     * Meta information extracted from the WSDL
     * - documentation: Crée une famille à rubriques libres pour les genre 'AGenres' de libellé 'ALibelle' dans la base
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aLibelle
     * @param \Hp_\StructType\Hp_THpSvcWTableauGenresFamille $aGenres
     * @return THpSvcWCleFamille|bool
     */
    public function CreerFamilleARubriquesLibres($aLibelle, \Hp_\StructType\Hp_THpSvcWTableauGenresFamille $aGenres)
    {
        try {
            $this->setResult($this->getSoapClient()->CreerFamilleARubriquesLibres($aLibelle, $aGenres));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return THpSvcWCleFamille|THpSvcWCleRubrique
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
