<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rubriques ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Rubriques extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RubriquesDeLaFamilleParLibelle
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de libellé 'ALibelle' de la famille 'AFamille'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aLibelle
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriquesDeLaFamilleParLibelle($aFamille, $aLibelle)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriquesDeLaFamilleParLibelle($aFamille, $aLibelle));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
