<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Nombre ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Nombre extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NombreFamillesDuGenre
     * Meta information extracted from the WSDL
     * - documentation: Nombre total de familles du genre 'AGenre' dans la base
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aGenre
     * @return unsignedInt|bool
     */
    public function NombreFamillesDuGenre($aGenre)
    {
        try {
            $this->setResult($this->getSoapClient()->NombreFamillesDuGenre($aGenre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NombreRubriquesDeLaFamille
     * Meta information extracted from the WSDL
     * - documentation: Nombre total de rubriques pour la famille de clé 'AFamille' dans la base. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @return unsignedInt|bool
     */
    public function NombreRubriquesDeLaFamille($aFamille)
    {
        try {
            $this->setResult($this->getSoapClient()->NombreRubriquesDeLaFamille($aFamille));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return unsignedInt
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
