<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Libelles ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Libelles extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LibellesTableauDeFamilles
     * Meta information extracted from the WSDL
     * - documentation: Libellé des familles dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau
     * @return \Hp_\StructType\Hp_THpSvcWTableauChaines|bool
     */
    public function LibellesTableauDeFamilles(\Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->LibellesTableauDeFamilles($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LibellesTableauDeRubriques
     * Meta information extracted from the WSDL
     * - documentation: Libellé des rubriques dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Hp_\StructType\Hp_THpSvcWTableauClesRubriques $aTableau
     * @return \Hp_\StructType\Hp_THpSvcWTableauChaines|bool
     */
    public function LibellesTableauDeRubriques(\Hp_\StructType\Hp_THpSvcWTableauClesRubriques $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->LibellesTableauDeRubriques($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Hp_\StructType\Hp_THpSvcWTableauChaines
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
