<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Libelle ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Libelle extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LibelleFamille
     * Meta information extracted from the WSDL
     * - documentation: Libellé de la famille de clé 'AFamille'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @return string|bool
     */
    public function LibelleFamille($aFamille)
    {
        try {
            $this->setResult($this->getSoapClient()->LibelleFamille($aFamille));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LibelleRubrique
     * Meta information extracted from the WSDL
     * - documentation: Libellé de la rubrique de clé 'ARubrique'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @return string|bool
     */
    public function LibelleRubrique($aRubrique)
    {
        try {
            $this->setResult($this->getSoapClient()->LibelleRubrique($aRubrique));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
