<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cles ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Cles extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * ClesFamillesValidesTableauDeFamilles
     * Meta information extracted from the WSDL
     * - documentation: Tableau contenant toutes les clés valides du tableau de clés 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesFamilles|bool
     */
    public function ClesFamillesValidesTableauDeFamilles(\Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->ClesFamillesValidesTableauDeFamilles($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ClesFamillesInvalidesTableauDeFamilles
     * Meta information extracted from the WSDL
     * - documentation: Tableau contenant toutes les clés invalides du tableau de clés 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesFamilles|bool
     */
    public function ClesFamillesInvalidesTableauDeFamilles(\Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->ClesFamillesInvalidesTableauDeFamilles($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ClesRubriquesValidesTableauDeRubriques
     * Meta information extracted from the WSDL
     * - documentation: Tableau contenant toutes les clés valides du tableau de clés 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Hp_\StructType\Hp_THpSvcWTableauClesRubriques $aTableau
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function ClesRubriquesValidesTableauDeRubriques(\Hp_\StructType\Hp_THpSvcWTableauClesRubriques $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->ClesRubriquesValidesTableauDeRubriques($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ClesRubriquesInvalidesTableauDeRubriques
     * Meta information extracted from the WSDL
     * - documentation: Tableau contenant toutes les clés invalides du tableau de clés 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Hp_\StructType\Hp_THpSvcWTableauClesRubriques $aTableau
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function ClesRubriquesInvalidesTableauDeRubriques(\Hp_\StructType\Hp_THpSvcWTableauClesRubriques $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->ClesRubriquesInvalidesTableauDeRubriques($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesFamilles|\Hp_\StructType\Hp_THpSvcWTableauClesRubriques
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
