<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ajouter ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Ajouter extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AjouterGenresFamille
     * Meta information extracted from the WSDL
     * - documentation: Ajoute les genres 'AGenres' à la famille de clé 'AFamille'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param \Hp_\StructType\Hp_THpSvcWTableauGenresFamille $aGenres
     * @return void|bool
     */
    public function AjouterGenresFamille($aFamille, \Hp_\StructType\Hp_THpSvcWTableauGenresFamille $aGenres)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterGenresFamille($aFamille, $aGenres));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueALaMatiere
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' à la matière de clé 'AMatiere'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aMatiere
     * @return void|bool
     */
    public function AjouterUneRubriqueALaMatiere($aRubrique, $aMatiere)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueALaMatiere($aRubrique, $aMatiere));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueALEnseignant
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' à l'enseignant de clé 'AEnseignant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aEnseignant
     * @return void|bool
     */
    public function AjouterUneRubriqueALEnseignant($aRubrique, $aEnseignant)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueALEnseignant($aRubrique, $aEnseignant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueALaPromotion
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' à la promotion de clé 'APromotion'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aPromotion
     * @return void|bool
     */
    public function AjouterUneRubriqueALaPromotion($aRubrique, $aPromotion)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueALaPromotion($aRubrique, $aPromotion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueAuTDOption
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' au TD/option de clé 'ATDOption'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aTDOption
     * @return void|bool
     */
    public function AjouterUneRubriqueAuTDOption($aRubrique, $aTDOption)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueAuTDOption($aRubrique, $aTDOption));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueAuRegroupement
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' au regroupement de clé 'ARegroupement'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aRegroupement
     * @return void|bool
     */
    public function AjouterUneRubriqueAuRegroupement($aRubrique, $aRegroupement)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueAuRegroupement($aRubrique, $aRegroupement));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueALEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' à l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aEtudiant
     * @return void|bool
     */
    public function AjouterUneRubriqueALEtudiant($aRubrique, $aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueALEtudiant($aRubrique, $aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueALaSalle
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' à la salle de clé 'ASalle'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aSalle
     * @return void|bool
     */
    public function AjouterUneRubriqueALaSalle($aRubrique, $aSalle)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueALaSalle($aRubrique, $aSalle));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueAuCursus
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' au cursus de clé 'ACursus'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aCursus
     * @return void|bool
     */
    public function AjouterUneRubriqueAuCursus($aRubrique, $aCursus)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueAuCursus($aRubrique, $aCursus));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueAuModule
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' au module de clé 'AModule'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aModule
     * @return void|bool
     */
    public function AjouterUneRubriqueAuModule($aRubrique, $aModule)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueAuModule($aRubrique, $aModule));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueAuCours
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' au cours de clé 'ACours'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aCours
     * @return void|bool
     */
    public function AjouterUneRubriqueAuCours($aRubrique, $aCours)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueAuCours($aRubrique, $aCours));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueALAppariteur
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' à l'appariteur de clé 'AAppariteur'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aAppariteur
     * @return void|bool
     */
    public function AjouterUneRubriqueALAppariteur($aRubrique, $aAppariteur)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueALAppariteur($aRubrique, $aAppariteur));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueAuType
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' au type 'AType'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aType
     * @return void|bool
     */
    public function AjouterUneRubriqueAuType($aRubrique, $aType)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueAuType($aRubrique, $aType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueALEntreprise
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' à l'entreprise de clé 'AEntreprise'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aEntreprise
     * @return void|bool
     */
    public function AjouterUneRubriqueALEntreprise($aRubrique, $aEntreprise)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueALEntreprise($aRubrique, $aEntreprise));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueAuContact
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' au contact de clé 'AContact'.Anciennement AjouterUneRubriqueAuMaitreStage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aContact
     * @return void|bool
     */
    public function AjouterUneRubriqueAuContact($aRubrique, $aContact)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueAuContact($aRubrique, $aContact));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueAuStage
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' au stage de clé 'AStage'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aStage
     * @return void|bool
     */
    public function AjouterUneRubriqueAuStage($aRubrique, $aStage)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueAuStage($aRubrique, $aStage));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterUneRubriqueALAlternance
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' à l'alternance de clé 'AAlternance'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aAlternance
     * @return void|bool
     */
    public function AjouterUneRubriqueALAlternance($aRubrique, $aAlternance)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueALAlternance($aRubrique, $aAlternance));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * AjouterUneRubriqueAuCalendrierNotation
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique'au calendrier de notation de clé 'ACalendrierNotation'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aCalendrierNotation
     * @return void|bool
     */
    public function AjouterUneRubriqueAuCalendrierNotation($aRubrique, $aCalendrierNotation)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueAuCalendrierNotation($aRubrique, $aCalendrierNotation));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * AjouterUneRubriqueALaPeriodeHorsCalendrier
     * Meta information extracted from the WSDL
     * - documentation: Ajoute la rubrique de clé 'ARubrique' à la période hors calendrier de clé 'APeriodeHorsCalendrier'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aPeriodeHorsCalendrier
     * @return void|bool
     */
    public function AjouterUneRubriqueALaPeriodeHorsCalendrier($aRubrique, $aPeriodeHorsCalendrier)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterUneRubriqueALaPeriodeHorsCalendrier($aRubrique, $aPeriodeHorsCalendrier));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
