<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rubrique ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Rubrique extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RubriqueDeLaMatiereDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées à la matière de clé 'AMatiere'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aMatiere
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDeLaMatiereDeFamille($aFamille, $aMatiere)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDeLaMatiereDeFamille($aFamille, $aMatiere));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueLibreDeLaMatiereDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée à la matière de clé 'AMatiere'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aMatiere
     * @return string|bool
     */
    public function RubriqueLibreDeLaMatiereDeFamille($aFamille, $aMatiere)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDeLaMatiereDeFamille($aFamille, $aMatiere));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueDeLEnseignantDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées à l'enseignant de clé 'AEnseignant'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aEnseignant
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDeLEnseignantDeFamille($aFamille, $aEnseignant)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDeLEnseignantDeFamille($aFamille, $aEnseignant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RubriqueLibreDeLEnseignantDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée à l'enseignant de clé 'AEnseignant'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aEnseignant
     * @return string|bool
     */
    public function RubriqueLibreDeLEnseignantDeFamille($aFamille, $aEnseignant)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDeLEnseignantDeFamille($aFamille, $aEnseignant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueDeLaPromotionDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées à la promotion de clé 'APromotion'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aPromotion
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDeLaPromotionDeFamille($aFamille, $aPromotion)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDeLaPromotionDeFamille($aFamille, $aPromotion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RubriqueLibreDeLaPromotionDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée à la promotion de clé 'APromotion'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aPromotion
     * @return string|bool
     */
    public function RubriqueLibreDeLaPromotionDeFamille($aFamille, $aPromotion)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDeLaPromotionDeFamille($aFamille, $aPromotion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueDuTDOptionDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées au TD/option de clé 'ATDOption'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aTDOption
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDuTDOptionDeFamille($aFamille, $aTDOption)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDuTDOptionDeFamille($aFamille, $aTDOption));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueLibreDuTDOptionDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée au TD/Option de clé 'ATDOption'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aTDOption
     * @return string|bool
     */
    public function RubriqueLibreDuTDOptionDeFamille($aFamille, $aTDOption)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDuTDOptionDeFamille($aFamille, $aTDOption));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueDuRegroupementDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées au regroupement de clé 'ARegroupement'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aRegroupement
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDuRegroupementDeFamille($aFamille, $aRegroupement)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDuRegroupementDeFamille($aFamille, $aRegroupement));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RubriqueLibreDuRegroupementDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée au regroupement de clé 'ARegroupement'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aRegroupement
     * @return string|bool
     */
    public function RubriqueLibreDuRegroupementDeFamille($aFamille, $aRegroupement)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDuRegroupementDeFamille($aFamille, $aRegroupement));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueDeLEtudiantDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées à l'étudiant de clé 'AEtudiant'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aEtudiant
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDeLEtudiantDeFamille($aFamille, $aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDeLEtudiantDeFamille($aFamille, $aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueLibreDeLEtudiantDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée à l'étudiant de clé 'AEtudiant'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aEtudiant
     * @return string|bool
     */
    public function RubriqueLibreDeLEtudiantDeFamille($aFamille, $aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDeLEtudiantDeFamille($aFamille, $aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueDeLaSalleDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées à la salle de clé 'ASalle'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aSalle
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDeLaSalleDeFamille($aFamille, $aSalle)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDeLaSalleDeFamille($aFamille, $aSalle));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueLibreDeLaSalleDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée à la salle de clé 'ASalle'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aSalle
     * @return string|bool
     */
    public function RubriqueLibreDeLaSalleDeFamille($aFamille, $aSalle)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDeLaSalleDeFamille($aFamille, $aSalle));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueDuCursusDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées au cursus de clé 'ACursus'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aCursus
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDuCursusDeFamille($aFamille, $aCursus)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDuCursusDeFamille($aFamille, $aCursus));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueLibreDuCursusDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée au cursus de clé 'ACursus'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aCursus
     * @return string|bool
     */
    public function RubriqueLibreDuCursusDeFamille($aFamille, $aCursus)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDuCursusDeFamille($aFamille, $aCursus));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueDuModuleDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées au module de clé 'AModule'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aModule
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDuModuleDeFamille($aFamille, $aModule)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDuModuleDeFamille($aFamille, $aModule));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueLibreDuModuleDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée au module de clé 'AModule'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aModule
     * @return string|bool
     */
    public function RubriqueLibreDuModuleDeFamille($aFamille, $aModule)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDuModuleDeFamille($aFamille, $aModule));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueDuCoursDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées au cours de clé 'ACours'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aCours
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDuCoursDeFamille($aFamille, $aCours)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDuCoursDeFamille($aFamille, $aCours));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueLibreDuCoursDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée au cours de clé 'ACours'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aCours
     * @return string|bool
     */
    public function RubriqueLibreDuCoursDeFamille($aFamille, $aCours)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDuCoursDeFamille($aFamille, $aCours));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueDeLAppariteurDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées à l'appariteur de clé 'AAppariteur'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aAppariteur
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDeLAppariteurDeFamille($aFamille, $aAppariteur)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDeLAppariteurDeFamille($aFamille, $aAppariteur));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RubriqueLibreDeLAppariteurDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée à l'appariteur de clé 'AAppariteur'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aAppariteur
     * @return string|bool
     */
    public function RubriqueLibreDeLAppariteurDeFamille($aFamille, $aAppariteur)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDeLAppariteurDeFamille($aFamille, $aAppariteur));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueDuTypeDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées au type 'AType'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aType
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDuTypeDeFamille($aFamille, $aType)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDuTypeDeFamille($aFamille, $aType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueLibreDuTypeDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée au type 'AType'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aType
     * @return string|bool
     */
    public function RubriqueLibreDuTypeDeFamille($aFamille, $aType)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDuTypeDeFamille($aFamille, $aType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueDEntrepriseDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées à l'entreprise de clé 'AEntreprise'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aEntreprise
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDEntrepriseDeFamille($aFamille, $aEntreprise)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDEntrepriseDeFamille($aFamille, $aEntreprise));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RubriqueLibreDeLEntrepriseDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée à l'entreprise de clé 'AEntreprise'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aEntreprise
     * @return string|bool
     */
    public function RubriqueLibreDeLEntrepriseDeFamille($aFamille, $aEntreprise)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDeLEntrepriseDeFamille($aFamille, $aEntreprise));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueDuContactDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées au contact de clé 'AContact'. Renvoie une exception si la famille est une famille à rubriques libres.Anciennement RubriqueDuMaitreStageDeFamille
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aContact
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDuContactDeFamille($aFamille, $aContact)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDuContactDeFamille($aFamille, $aContact));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueLibreDuContactDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée au contact de clé 'AContact'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aContact
     * @return string|bool
     */
    public function RubriqueLibreDuContactDeFamille($aFamille, $aContact)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDuContactDeFamille($aFamille, $aContact));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueDuStageDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées au stage de clé 'AStage'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aStage
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDuStageDeFamille($aFamille, $aStage)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDuStageDeFamille($aFamille, $aStage));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueLibreDuStageDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée au stage de clé 'AStage'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aStage
     * @return string|bool
     */
    public function RubriqueLibreDuStageDeFamille($aFamille, $aStage)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDuStageDeFamille($aFamille, $aStage));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RubriqueDeLAlternanceDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées à l'alternance de clé 'AAlternance'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aAlternance
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDeLAlternanceDeFamille($aFamille, $aAlternance)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDeLAlternanceDeFamille($aFamille, $aAlternance));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RubriqueLibreDeLAlternanceDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée à l'alternance de clé 'AAlternance'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aAlternance
     * @return string|bool
     */
    public function RubriqueLibreDeLAlternanceDeFamille($aFamille, $aAlternance)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDeLAlternanceDeFamille($aFamille, $aAlternance));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RubriqueDuCalendrierNotationDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées au calendrier de notation de clé 'ACalendrierNotation'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aCalendrierNotation
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDuCalendrierNotationDeFamille($aFamille, $aCalendrierNotation)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDuCalendrierNotationDeFamille($aFamille, $aCalendrierNotation));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RubriqueDePeriodeHorsCalendrierDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Clés des rubriques de la famille de clé 'AFamille' attribuées à la période hors calendrier de clé 'APeriodeHorsCalendrier'. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aPeriodeHorsCalendrier
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function RubriqueDePeriodeHorsCalendrierDeFamille($aFamille, $aPeriodeHorsCalendrier)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueDePeriodeHorsCalendrierDeFamille($aFamille, $aPeriodeHorsCalendrier));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RubriqueLibreDuCalendrierNotationDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée au calendrier de notation de clé 'ACalendrierNotation'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aCalendrierNotation
     * @return string|bool
     */
    public function RubriqueLibreDuCalendrierNotationDeFamille($aFamille, $aCalendrierNotation)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDuCalendrierNotationDeFamille($aFamille, $aCalendrierNotation));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RubriqueLibreDePeriodeHorsCalendrierDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Rubrique libre de la famille de clé 'AFamille' attribuée à la période hors calendrier de clé 'APeriodeHorsCalendrier'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aPeriodeHorsCalendrier
     * @return string|bool
     */
    public function RubriqueLibreDePeriodeHorsCalendrierDeFamille($aFamille, $aPeriodeHorsCalendrier)
    {
        try {
            $this->setResult($this->getSoapClient()->RubriqueLibreDePeriodeHorsCalendrierDeFamille($aFamille, $aPeriodeHorsCalendrier));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\Hp_\StructType\Hp_THpSvcWTableauClesRubriques
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
