<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Restreindre ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Restreindre extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * RestreindreTableauDeFamillesAuxFamillesARubriquesPredefinies
     * Meta information extracted from the WSDL
     * - documentation: Tableau contenant les clés des familles à rubriques prédéfinies du tableau de clés 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesFamilles|bool
     */
    public function RestreindreTableauDeFamillesAuxFamillesARubriquesPredefinies(\Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->RestreindreTableauDeFamillesAuxFamillesARubriquesPredefinies($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * RestreindreTableauDeFamillesAuxFamillesARubriquesLibres
     * Meta information extracted from the WSDL
     * - documentation: Tableau contenant les clés des familles à rubriques libres du tableau de clés 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesFamilles|bool
     */
    public function RestreindreTableauDeFamillesAuxFamillesARubriquesLibres(\Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->RestreindreTableauDeFamillesAuxFamillesARubriquesLibres($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesFamilles
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
