<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Modifier ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Modifier extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ModifierLibelleFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie le libellé de la famille de clé 'AFamille'. Si la famille est du genre Utilisateur : Opération autorisée seulement pour un administrateur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aLibelle
     * @return void|bool
     */
    public function ModifierLibelleFamille($aFamille, $aLibelle)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierLibelleFamille($aFamille, $aLibelle));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierLibelleRubrique
     * Meta information extracted from the WSDL
     * - documentation: Modifie le libellé de la rubrique de clé 'ARubrique'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aLibelle
     * @return void|bool
     */
    public function ModifierLibelleRubrique($aRubrique, $aLibelle)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierLibelleRubrique($aRubrique, $aLibelle));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDeLaMatiereDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' de la matière de clé 'AMatiere' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aMatiere
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDeLaMatiereDeFamille($aFamille, $aMatiere, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDeLaMatiereDeFamille($aFamille, $aMatiere, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDeLEnseignantDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' de l'enseignant de clé 'AEnseignant' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aEnseignant
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDeLEnseignantDeFamille($aFamille, $aEnseignant, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDeLEnseignantDeFamille($aFamille, $aEnseignant, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDeLaPromotionDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' de la promotion de clé 'APromotion' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aPromotion
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDeLaPromotionDeFamille($aFamille, $aPromotion, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDeLaPromotionDeFamille($aFamille, $aPromotion, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDuTDOptionDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' du TD/Option de clé 'ATDOption' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aTDOption
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDuTDOptionDeFamille($aFamille, $aTDOption, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDuTDOptionDeFamille($aFamille, $aTDOption, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDuRegroupementDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' du regroupement de clé 'ARegroupement' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aRegroupement
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDuRegroupementDeFamille($aFamille, $aRegroupement, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDuRegroupementDeFamille($aFamille, $aRegroupement, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDeLEtudiantDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' de l'étudiant de clé 'AEtudiant' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aEtudiant
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDeLEtudiantDeFamille($aFamille, $aEtudiant, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDeLEtudiantDeFamille($aFamille, $aEtudiant, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDeLaSalleDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' de la salle de clé 'ASalle' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aSalle
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDeLaSalleDeFamille($aFamille, $aSalle, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDeLaSalleDeFamille($aFamille, $aSalle, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDuCursusDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' du cursus de clé 'ACursus' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aCursus
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDuCursusDeFamille($aFamille, $aCursus, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDuCursusDeFamille($aFamille, $aCursus, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDuModuleDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' du module de clé 'AModule' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aModule
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDuModuleDeFamille($aFamille, $aModule, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDuModuleDeFamille($aFamille, $aModule, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDuCoursDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' du cours de clé 'ACours' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aCours
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDuCoursDeFamille($aFamille, $aCours, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDuCoursDeFamille($aFamille, $aCours, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDeLAppariteurDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' de l'appariteur de clé 'AAppariteur' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aAppariteur
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDeLAppariteurDeFamille($aFamille, $aAppariteur, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDeLAppariteurDeFamille($aFamille, $aAppariteur, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDuTypeDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' du type 'AType' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aType
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDuTypeDeFamille($aFamille, $aType, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDuTypeDeFamille($aFamille, $aType, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDeLEntrepriseDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' de l'entreprise de clé 'AEntreprise' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aEntreprise
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDeLEntrepriseDeFamille($aFamille, $aEntreprise, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDeLEntrepriseDeFamille($aFamille, $aEntreprise, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDuContactDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' du contact de clé 'AContact' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aContact
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDuContactDeFamille($aFamille, $aContact, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDuContactDeFamille($aFamille, $aContact, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDuStageDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' du stage de clé 'AStage' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aStage
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDuStageDeFamille($aFamille, $aStage, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDuStageDeFamille($aFamille, $aStage, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDeLAlternanceDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' de l'alternance de clé 'AAlternance' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aAlternance
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDeLAlternanceDeFamille($aFamille, $aAlternance, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDeLAlternanceDeFamille($aFamille, $aAlternance, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDuCalendrierNotationDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' du calendrier de notation de clé 'ACalendrierNotation' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aCalendrierNotation
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDuCalendrierNotationDeFamille($aFamille, $aCalendrierNotation, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDuCalendrierNotationDeFamille($aFamille, $aCalendrierNotation, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierRubriqueLibreDePeriodeHorsCalendrierDeFamille
     * Meta information extracted from the WSDL
     * - documentation: Modifie la rubrique libre 'ARubriqueLibre' de la période hors calendrier de clé 'APeriodeHorsCalendrier' pour la famille de clé 'AFamille'. Renvoie une exception si la famille est une famille à rubriques prédéfinies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param string $aPeriodeHorsCalendrier
     * @param string $aRubriqueLibre
     * @return void|bool
     */
    public function ModifierRubriqueLibreDePeriodeHorsCalendrierDeFamille($aFamille, $aPeriodeHorsCalendrier, $aRubriqueLibre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRubriqueLibreDePeriodeHorsCalendrierDeFamille($aFamille, $aPeriodeHorsCalendrier, $aRubriqueLibre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
