<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Genres ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Genres extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GenresFamille
     * Meta information extracted from the WSDL
     * - documentation: Genres de la famille de clé 'AFamille'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @return \Hp_\StructType\Hp_THpSvcWTableauGenresFamille|bool
     */
    public function GenresFamille($aFamille)
    {
        try {
            $this->setResult($this->getSoapClient()->GenresFamille($aFamille));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Hp_\StructType\Hp_THpSvcWTableauGenresFamille
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
