<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Est ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Est extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EstUneFamilleARubriquesPredefinies
     * Meta information extracted from the WSDL
     * - documentation: Vrai si la famille de clé 'AFamille' est une famille à rubriques prédéfinies, faux sinon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @return boolean|bool
     */
    public function EstUneFamilleARubriquesPredefinies($aFamille)
    {
        try {
            $this->setResult($this->getSoapClient()->EstUneFamilleARubriquesPredefinies($aFamille));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EstUneFamilleARubriquesLibres
     * Meta information extracted from the WSDL
     * - documentation: Vrai si la famille de clé 'AFamille' est une famille à rubriques libres, faux sinon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @return boolean|bool
     */
    public function EstUneFamilleARubriquesLibres($aFamille)
    {
        try {
            $this->setResult($this->getSoapClient()->EstUneFamilleARubriquesLibres($aFamille));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
