<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Enlever ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Enlever extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EnleverGenresFamille
     * Meta information extracted from the WSDL
     * - documentation: Enlève les genres 'AGenres' à la famille de clé 'AFamille'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @param \Hp_\StructType\Hp_THpSvcWTableauGenresFamille $aGenres
     * @return void|bool
     */
    public function EnleverGenresFamille($aFamille, \Hp_\StructType\Hp_THpSvcWTableauGenresFamille $aGenres)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverGenresFamille($aFamille, $aGenres));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueALaMatiere
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' à la matière de clé 'AMatiere'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aMatiere
     * @return void|bool
     */
    public function EnleverUneRubriqueALaMatiere($aRubrique, $aMatiere)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueALaMatiere($aRubrique, $aMatiere));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueALEnseignant
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' à l'enseignant de clé 'AEnseignant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aEnseignant
     * @return void|bool
     */
    public function EnleverUneRubriqueALEnseignant($aRubrique, $aEnseignant)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueALEnseignant($aRubrique, $aEnseignant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueALaPromotion
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' à la promotion de clé 'APromotion'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aPromotion
     * @return void|bool
     */
    public function EnleverUneRubriqueALaPromotion($aRubrique, $aPromotion)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueALaPromotion($aRubrique, $aPromotion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueAuTDOption
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' au TD/option de clé 'ATDOption'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aTDOption
     * @return void|bool
     */
    public function EnleverUneRubriqueAuTDOption($aRubrique, $aTDOption)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueAuTDOption($aRubrique, $aTDOption));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueAuRegroupement
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' au regroupement de clé 'ARegroupement'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aRegroupement
     * @return void|bool
     */
    public function EnleverUneRubriqueAuRegroupement($aRubrique, $aRegroupement)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueAuRegroupement($aRubrique, $aRegroupement));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueALEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' à l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aEtudiant
     * @return void|bool
     */
    public function EnleverUneRubriqueALEtudiant($aRubrique, $aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueALEtudiant($aRubrique, $aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueALaSalle
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' à la salle de clé 'ASalle'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aSalle
     * @return void|bool
     */
    public function EnleverUneRubriqueALaSalle($aRubrique, $aSalle)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueALaSalle($aRubrique, $aSalle));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueAuCursus
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' au cursus de clé 'ACursus'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aCursus
     * @return void|bool
     */
    public function EnleverUneRubriqueAuCursus($aRubrique, $aCursus)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueAuCursus($aRubrique, $aCursus));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueAuModule
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' au module de clé 'AModule'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aModule
     * @return void|bool
     */
    public function EnleverUneRubriqueAuModule($aRubrique, $aModule)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueAuModule($aRubrique, $aModule));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueAuCours
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' au cours de clé 'ACours'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aCours
     * @return void|bool
     */
    public function EnleverUneRubriqueAuCours($aRubrique, $aCours)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueAuCours($aRubrique, $aCours));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueALAppariteur
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' à l'appariteur de clé 'AAppariteur'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aAppariteur
     * @return void|bool
     */
    public function EnleverUneRubriqueALAppariteur($aRubrique, $aAppariteur)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueALAppariteur($aRubrique, $aAppariteur));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueAuType
     * Meta information extracted from the WSDL
     * - documentation: Enlève la rubrique de clé 'ARubrique' au type 'AType'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aType
     * @return void|bool
     */
    public function EnleverUneRubriqueAuType($aRubrique, $aType)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueAuType($aRubrique, $aType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueALEntreprise
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' à l'entreprise de clé 'AEntreprise'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aEntreprise
     * @return void|bool
     */
    public function EnleverUneRubriqueALEntreprise($aRubrique, $aEntreprise)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueALEntreprise($aRubrique, $aEntreprise));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueAuContact
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' au contact de clé 'AContact'.Anciennement EnleverUneRubriqueAuMaitreStage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aContact
     * @return void|bool
     */
    public function EnleverUneRubriqueAuContact($aRubrique, $aContact)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueAuContact($aRubrique, $aContact));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueAuStage
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' au stage de clé 'AStage'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aStage
     * @return void|bool
     */
    public function EnleverUneRubriqueAuStage($aRubrique, $aStage)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueAuStage($aRubrique, $aStage));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverUneRubriqueALAlternance
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' à l'alternance de clé 'AAlternance'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aAlternance
     * @return void|bool
     */
    public function EnleverUneRubriqueALAlternance($aRubrique, $aAlternance)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueALAlternance($aRubrique, $aAlternance));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * EnleverUneRubriqueAuCalendrierNotation
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique'au calendrier de notation de clé 'ACalendrierNotation'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aCalendrierNotation
     * @return void|bool
     */
    public function EnleverUneRubriqueAuCalendrierNotation($aRubrique, $aCalendrierNotation)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueAuCalendrierNotation($aRubrique, $aCalendrierNotation));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * EnleverUneRubriqueALaPeriodeHorsCalendrier
     * Meta information extracted from the WSDL
     * - documentation: Enleve la rubrique de clé 'ARubrique' à la période hors calendrier de clé 'APeriodeHorsCalendrier'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @param string $aPeriodeHorsCalendrier
     * @return void|bool
     */
    public function EnleverUneRubriqueALaPeriodeHorsCalendrier($aRubrique, $aPeriodeHorsCalendrier)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverUneRubriqueALaPeriodeHorsCalendrier($aRubrique, $aPeriodeHorsCalendrier));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
