<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cle ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Cle extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CleFamilleEstValide
     * Meta information extracted from the WSDL
     * - documentation: Vrai si la clé famille 'AFamille' est valide, faux sinon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @return boolean|bool
     */
    public function CleFamilleEstValide($aFamille)
    {
        try {
            $this->setResult($this->getSoapClient()->CleFamilleEstValide($aFamille));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CleRubriqueEstValide
     * Meta information extracted from the WSDL
     * - documentation: Vrai si la clé rubrique 'ARubrique' est valide, faux sinon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @return boolean|bool
     */
    public function CleRubriqueEstValide($aRubrique)
    {
        try {
            $this->setResult($this->getSoapClient()->CleRubriqueEstValide($aRubrique));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
