<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VATYPE StructType
 * @subpackage Structs
 */
class VATYPE extends AbstractStructBase
{
    /**
     * The ImporteSeguro
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 6
     * - minOccurs: 0
     * - ref: xsd:ImporteSeguro
     * @var string
     */
    public $ImporteSeguro;
    /**
     * The Reembolso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:Reembolso
     * @var \StructType\REEMBOLSOTYPE
     */
    public $Reembolso;
    /**
     * The EntregaExclusivaDestinatario
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * - ref: xsd:EntregaExclusivaDestinatario
     * @var string
     */
    public $EntregaExclusivaDestinatario;
    /**
     * The PruebaEntrega
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:PruebaEntrega
     * @var \StructType\PRUEBAENTREGATYPE
     */
    public $PruebaEntrega;
    /**
     * The Recogidaadomicilio
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * - ref: xsd:Recogidaadomicilio
     * @var string
     */
    public $Recogidaadomicilio;
    /**
     * The DevolucionAlbaran
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * - ref: xsd:DevolucionAlbaran
     * @var string
     */
    public $DevolucionAlbaran;
    /**
     * The RepartoenSabado
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * - ref: xsd:RepartoenSabado
     * @var string
     */
    public $RepartoenSabado;
    /**
     * The EntregaConcertada
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - ref: xsd:EntregaConcertada
     * @var string
     */
    public $EntregaConcertada;
    /**
     * The FranjaHorariaConcertada
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - ref: xsd:FranjaHorariaConcertada
     * @var string
     */
    public $FranjaHorariaConcertada;
    /**
     * The EntregaconRecogida
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * - ref: xsd:EntregaconRecogida
     * @var string
     */
    public $EntregaconRecogida;
    /**
     * The IndImprimirEtiqueta
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * - ref: xsd:IndImprimirEtiqueta
     * @var string
     */
    public $IndImprimirEtiqueta;
    /**
     * The TextoAdicional
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * - ref: xsd:TextoAdicional
     * @var string
     */
    public $TextoAdicional;
    /**
     * The TiempoEnLista
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:TiempoEnLista
     * @var int
     */
    public $TiempoEnLista;
    /**
     * The IntentosDeEntrega
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:IntentosDeEntrega
     * @var int
     */
    public $IntentosDeEntrega;
    /**
     * The EntregaSinFirmar
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * - ref: xsd:EntregaSinFirmar
     * @var string
     */
    public $EntregaSinFirmar;
    /**
     * The ComplejidadGestion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:ComplejidadGestion
     * @var string
     */
    public $ComplejidadGestion;
    /**
     * The AutorizacionPreviaEntrega
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:AutorizacionPreviaEntrega
     * @var string
     */
    public $AutorizacionPreviaEntrega;
    /**
     * The TarifaPlana
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:TarifaPlana
     * @var string
     */
    public $TarifaPlana;
    /**
     * The IdClienteTarifaPlana
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * - ref: xsd:IdClienteTarifaPlana
     * @var string
     */
    public $IdClienteTarifaPlana;
    /**
     * The IdOperacion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:IdOperacion
     * @var string
     */
    public $IdOperacion;
    /**
     * Constructor method for VATYPE
     * @uses VATYPE::setImporteSeguro()
     * @uses VATYPE::setReembolso()
     * @uses VATYPE::setEntregaExclusivaDestinatario()
     * @uses VATYPE::setPruebaEntrega()
     * @uses VATYPE::setRecogidaadomicilio()
     * @uses VATYPE::setDevolucionAlbaran()
     * @uses VATYPE::setRepartoenSabado()
     * @uses VATYPE::setEntregaConcertada()
     * @uses VATYPE::setFranjaHorariaConcertada()
     * @uses VATYPE::setEntregaconRecogida()
     * @uses VATYPE::setIndImprimirEtiqueta()
     * @uses VATYPE::setTextoAdicional()
     * @uses VATYPE::setTiempoEnLista()
     * @uses VATYPE::setIntentosDeEntrega()
     * @uses VATYPE::setEntregaSinFirmar()
     * @uses VATYPE::setComplejidadGestion()
     * @uses VATYPE::setAutorizacionPreviaEntrega()
     * @uses VATYPE::setTarifaPlana()
     * @uses VATYPE::setIdClienteTarifaPlana()
     * @uses VATYPE::setIdOperacion()
     * @param string $importeSeguro
     * @param \StructType\REEMBOLSOTYPE $reembolso
     * @param string $entregaExclusivaDestinatario
     * @param \StructType\PRUEBAENTREGATYPE $pruebaEntrega
     * @param string $recogidaadomicilio
     * @param string $devolucionAlbaran
     * @param string $repartoenSabado
     * @param string $entregaConcertada
     * @param string $franjaHorariaConcertada
     * @param string $entregaconRecogida
     * @param string $indImprimirEtiqueta
     * @param string $textoAdicional
     * @param int $tiempoEnLista
     * @param int $intentosDeEntrega
     * @param string $entregaSinFirmar
     * @param string $complejidadGestion
     * @param string $autorizacionPreviaEntrega
     * @param string $tarifaPlana
     * @param string $idClienteTarifaPlana
     * @param string $idOperacion
     */
    public function __construct($importeSeguro = null, \StructType\REEMBOLSOTYPE $reembolso = null, $entregaExclusivaDestinatario = null, \StructType\PRUEBAENTREGATYPE $pruebaEntrega = null, $recogidaadomicilio = null, $devolucionAlbaran = null, $repartoenSabado = null, $entregaConcertada = null, $franjaHorariaConcertada = null, $entregaconRecogida = null, $indImprimirEtiqueta = null, $textoAdicional = null, $tiempoEnLista = null, $intentosDeEntrega = null, $entregaSinFirmar = null, $complejidadGestion = null, $autorizacionPreviaEntrega = null, $tarifaPlana = null, $idClienteTarifaPlana = null, $idOperacion = null)
    {
        $this
            ->setImporteSeguro($importeSeguro)
            ->setReembolso($reembolso)
            ->setEntregaExclusivaDestinatario($entregaExclusivaDestinatario)
            ->setPruebaEntrega($pruebaEntrega)
            ->setRecogidaadomicilio($recogidaadomicilio)
            ->setDevolucionAlbaran($devolucionAlbaran)
            ->setRepartoenSabado($repartoenSabado)
            ->setEntregaConcertada($entregaConcertada)
            ->setFranjaHorariaConcertada($franjaHorariaConcertada)
            ->setEntregaconRecogida($entregaconRecogida)
            ->setIndImprimirEtiqueta($indImprimirEtiqueta)
            ->setTextoAdicional($textoAdicional)
            ->setTiempoEnLista($tiempoEnLista)
            ->setIntentosDeEntrega($intentosDeEntrega)
            ->setEntregaSinFirmar($entregaSinFirmar)
            ->setComplejidadGestion($complejidadGestion)
            ->setAutorizacionPreviaEntrega($autorizacionPreviaEntrega)
            ->setTarifaPlana($tarifaPlana)
            ->setIdClienteTarifaPlana($idClienteTarifaPlana)
            ->setIdOperacion($idOperacion);
    }
    /**
     * Get ImporteSeguro value
     * @return string|null
     */
    public function getImporteSeguro()
    {
        return $this->ImporteSeguro;
    }
    /**
     * Set ImporteSeguro value
     * @param string $importeSeguro
     * @return \StructType\VATYPE
     */
    public function setImporteSeguro($importeSeguro = null)
    {
        // validation for constraint: string
        if (!is_null($importeSeguro) && !is_string($importeSeguro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importeSeguro, true), gettype($importeSeguro)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($importeSeguro) && mb_strlen($importeSeguro) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($importeSeguro)), __LINE__);
        }
        $this->ImporteSeguro = $importeSeguro;
        return $this;
    }
    /**
     * Get Reembolso value
     * @return \StructType\REEMBOLSOTYPE|null
     */
    public function getReembolso()
    {
        return $this->Reembolso;
    }
    /**
     * Set Reembolso value
     * @param \StructType\REEMBOLSOTYPE $reembolso
     * @return \StructType\VATYPE
     */
    public function setReembolso(\StructType\REEMBOLSOTYPE $reembolso = null)
    {
        $this->Reembolso = $reembolso;
        return $this;
    }
    /**
     * Get EntregaExclusivaDestinatario value
     * @return string|null
     */
    public function getEntregaExclusivaDestinatario()
    {
        return $this->EntregaExclusivaDestinatario;
    }
    /**
     * Set EntregaExclusivaDestinatario value
     * @param string $entregaExclusivaDestinatario
     * @return \StructType\VATYPE
     */
    public function setEntregaExclusivaDestinatario($entregaExclusivaDestinatario = null)
    {
        // validation for constraint: string
        if (!is_null($entregaExclusivaDestinatario) && !is_string($entregaExclusivaDestinatario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entregaExclusivaDestinatario, true), gettype($entregaExclusivaDestinatario)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($entregaExclusivaDestinatario) && mb_strlen($entregaExclusivaDestinatario) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($entregaExclusivaDestinatario)), __LINE__);
        }
        $this->EntregaExclusivaDestinatario = $entregaExclusivaDestinatario;
        return $this;
    }
    /**
     * Get PruebaEntrega value
     * @return \StructType\PRUEBAENTREGATYPE|null
     */
    public function getPruebaEntrega()
    {
        return $this->PruebaEntrega;
    }
    /**
     * Set PruebaEntrega value
     * @param \StructType\PRUEBAENTREGATYPE $pruebaEntrega
     * @return \StructType\VATYPE
     */
    public function setPruebaEntrega(\StructType\PRUEBAENTREGATYPE $pruebaEntrega = null)
    {
        $this->PruebaEntrega = $pruebaEntrega;
        return $this;
    }
    /**
     * Get Recogidaadomicilio value
     * @return string|null
     */
    public function getRecogidaadomicilio()
    {
        return $this->Recogidaadomicilio;
    }
    /**
     * Set Recogidaadomicilio value
     * @param string $recogidaadomicilio
     * @return \StructType\VATYPE
     */
    public function setRecogidaadomicilio($recogidaadomicilio = null)
    {
        // validation for constraint: string
        if (!is_null($recogidaadomicilio) && !is_string($recogidaadomicilio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recogidaadomicilio, true), gettype($recogidaadomicilio)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($recogidaadomicilio) && mb_strlen($recogidaadomicilio) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($recogidaadomicilio)), __LINE__);
        }
        $this->Recogidaadomicilio = $recogidaadomicilio;
        return $this;
    }
    /**
     * Get DevolucionAlbaran value
     * @return string|null
     */
    public function getDevolucionAlbaran()
    {
        return $this->DevolucionAlbaran;
    }
    /**
     * Set DevolucionAlbaran value
     * @param string $devolucionAlbaran
     * @return \StructType\VATYPE
     */
    public function setDevolucionAlbaran($devolucionAlbaran = null)
    {
        // validation for constraint: string
        if (!is_null($devolucionAlbaran) && !is_string($devolucionAlbaran)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($devolucionAlbaran, true), gettype($devolucionAlbaran)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($devolucionAlbaran) && mb_strlen($devolucionAlbaran) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($devolucionAlbaran)), __LINE__);
        }
        $this->DevolucionAlbaran = $devolucionAlbaran;
        return $this;
    }
    /**
     * Get RepartoenSabado value
     * @return string|null
     */
    public function getRepartoenSabado()
    {
        return $this->RepartoenSabado;
    }
    /**
     * Set RepartoenSabado value
     * @param string $repartoenSabado
     * @return \StructType\VATYPE
     */
    public function setRepartoenSabado($repartoenSabado = null)
    {
        // validation for constraint: string
        if (!is_null($repartoenSabado) && !is_string($repartoenSabado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repartoenSabado, true), gettype($repartoenSabado)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($repartoenSabado) && mb_strlen($repartoenSabado) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($repartoenSabado)), __LINE__);
        }
        $this->RepartoenSabado = $repartoenSabado;
        return $this;
    }
    /**
     * Get EntregaConcertada value
     * @return string|null
     */
    public function getEntregaConcertada()
    {
        return $this->EntregaConcertada;
    }
    /**
     * Set EntregaConcertada value
     * @param string $entregaConcertada
     * @return \StructType\VATYPE
     */
    public function setEntregaConcertada($entregaConcertada = null)
    {
        // validation for constraint: string
        if (!is_null($entregaConcertada) && !is_string($entregaConcertada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entregaConcertada, true), gettype($entregaConcertada)), __LINE__);
        }
        $this->EntregaConcertada = $entregaConcertada;
        return $this;
    }
    /**
     * Get FranjaHorariaConcertada value
     * @return string|null
     */
    public function getFranjaHorariaConcertada()
    {
        return $this->FranjaHorariaConcertada;
    }
    /**
     * Set FranjaHorariaConcertada value
     * @param string $franjaHorariaConcertada
     * @return \StructType\VATYPE
     */
    public function setFranjaHorariaConcertada($franjaHorariaConcertada = null)
    {
        // validation for constraint: string
        if (!is_null($franjaHorariaConcertada) && !is_string($franjaHorariaConcertada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($franjaHorariaConcertada, true), gettype($franjaHorariaConcertada)), __LINE__);
        }
        $this->FranjaHorariaConcertada = $franjaHorariaConcertada;
        return $this;
    }
    /**
     * Get EntregaconRecogida value
     * @return string|null
     */
    public function getEntregaconRecogida()
    {
        return $this->EntregaconRecogida;
    }
    /**
     * Set EntregaconRecogida value
     * @param string $entregaconRecogida
     * @return \StructType\VATYPE
     */
    public function setEntregaconRecogida($entregaconRecogida = null)
    {
        // validation for constraint: string
        if (!is_null($entregaconRecogida) && !is_string($entregaconRecogida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entregaconRecogida, true), gettype($entregaconRecogida)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($entregaconRecogida) && mb_strlen($entregaconRecogida) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($entregaconRecogida)), __LINE__);
        }
        $this->EntregaconRecogida = $entregaconRecogida;
        return $this;
    }
    /**
     * Get IndImprimirEtiqueta value
     * @return string|null
     */
    public function getIndImprimirEtiqueta()
    {
        return $this->IndImprimirEtiqueta;
    }
    /**
     * Set IndImprimirEtiqueta value
     * @param string $indImprimirEtiqueta
     * @return \StructType\VATYPE
     */
    public function setIndImprimirEtiqueta($indImprimirEtiqueta = null)
    {
        // validation for constraint: string
        if (!is_null($indImprimirEtiqueta) && !is_string($indImprimirEtiqueta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indImprimirEtiqueta, true), gettype($indImprimirEtiqueta)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($indImprimirEtiqueta) && mb_strlen($indImprimirEtiqueta) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($indImprimirEtiqueta)), __LINE__);
        }
        $this->IndImprimirEtiqueta = $indImprimirEtiqueta;
        return $this;
    }
    /**
     * Get TextoAdicional value
     * @return string|null
     */
    public function getTextoAdicional()
    {
        return $this->TextoAdicional;
    }
    /**
     * Set TextoAdicional value
     * @param string $textoAdicional
     * @return \StructType\VATYPE
     */
    public function setTextoAdicional($textoAdicional = null)
    {
        // validation for constraint: string
        if (!is_null($textoAdicional) && !is_string($textoAdicional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($textoAdicional, true), gettype($textoAdicional)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($textoAdicional) && mb_strlen($textoAdicional) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($textoAdicional)), __LINE__);
        }
        $this->TextoAdicional = $textoAdicional;
        return $this;
    }
    /**
     * Get TiempoEnLista value
     * @return int|null
     */
    public function getTiempoEnLista()
    {
        return $this->TiempoEnLista;
    }
    /**
     * Set TiempoEnLista value
     * @param int $tiempoEnLista
     * @return \StructType\VATYPE
     */
    public function setTiempoEnLista($tiempoEnLista = null)
    {
        // validation for constraint: int
        if (!is_null($tiempoEnLista) && !(is_int($tiempoEnLista) || ctype_digit($tiempoEnLista))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tiempoEnLista, true), gettype($tiempoEnLista)), __LINE__);
        }
        $this->TiempoEnLista = $tiempoEnLista;
        return $this;
    }
    /**
     * Get IntentosDeEntrega value
     * @return int|null
     */
    public function getIntentosDeEntrega()
    {
        return $this->IntentosDeEntrega;
    }
    /**
     * Set IntentosDeEntrega value
     * @param int $intentosDeEntrega
     * @return \StructType\VATYPE
     */
    public function setIntentosDeEntrega($intentosDeEntrega = null)
    {
        // validation for constraint: int
        if (!is_null($intentosDeEntrega) && !(is_int($intentosDeEntrega) || ctype_digit($intentosDeEntrega))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intentosDeEntrega, true), gettype($intentosDeEntrega)), __LINE__);
        }
        $this->IntentosDeEntrega = $intentosDeEntrega;
        return $this;
    }
    /**
     * Get EntregaSinFirmar value
     * @return string|null
     */
    public function getEntregaSinFirmar()
    {
        return $this->EntregaSinFirmar;
    }
    /**
     * Set EntregaSinFirmar value
     * @param string $entregaSinFirmar
     * @return \StructType\VATYPE
     */
    public function setEntregaSinFirmar($entregaSinFirmar = null)
    {
        // validation for constraint: string
        if (!is_null($entregaSinFirmar) && !is_string($entregaSinFirmar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entregaSinFirmar, true), gettype($entregaSinFirmar)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($entregaSinFirmar) && mb_strlen($entregaSinFirmar) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($entregaSinFirmar)), __LINE__);
        }
        $this->EntregaSinFirmar = $entregaSinFirmar;
        return $this;
    }
    /**
     * Get ComplejidadGestion value
     * @return string|null
     */
    public function getComplejidadGestion()
    {
        return $this->ComplejidadGestion;
    }
    /**
     * Set ComplejidadGestion value
     * @uses \EnumType\ComplejidadGestion::valueIsValid()
     * @uses \EnumType\ComplejidadGestion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $complejidadGestion
     * @return \StructType\VATYPE
     */
    public function setComplejidadGestion($complejidadGestion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComplejidadGestion::valueIsValid($complejidadGestion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ComplejidadGestion', is_array($complejidadGestion) ? implode(', ', $complejidadGestion) : var_export($complejidadGestion, true), implode(', ', \EnumType\ComplejidadGestion::getValidValues())), __LINE__);
        }
        $this->ComplejidadGestion = $complejidadGestion;
        return $this;
    }
    /**
     * Get AutorizacionPreviaEntrega value
     * @return string|null
     */
    public function getAutorizacionPreviaEntrega()
    {
        return $this->AutorizacionPreviaEntrega;
    }
    /**
     * Set AutorizacionPreviaEntrega value
     * @uses \EnumType\AutorizacionPreviaEntrega::valueIsValid()
     * @uses \EnumType\AutorizacionPreviaEntrega::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $autorizacionPreviaEntrega
     * @return \StructType\VATYPE
     */
    public function setAutorizacionPreviaEntrega($autorizacionPreviaEntrega = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AutorizacionPreviaEntrega::valueIsValid($autorizacionPreviaEntrega)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AutorizacionPreviaEntrega', is_array($autorizacionPreviaEntrega) ? implode(', ', $autorizacionPreviaEntrega) : var_export($autorizacionPreviaEntrega, true), implode(', ', \EnumType\AutorizacionPreviaEntrega::getValidValues())), __LINE__);
        }
        $this->AutorizacionPreviaEntrega = $autorizacionPreviaEntrega;
        return $this;
    }
    /**
     * Get TarifaPlana value
     * @return string|null
     */
    public function getTarifaPlana()
    {
        return $this->TarifaPlana;
    }
    /**
     * Set TarifaPlana value
     * @uses \EnumType\TarifaPlana::valueIsValid()
     * @uses \EnumType\TarifaPlana::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tarifaPlana
     * @return \StructType\VATYPE
     */
    public function setTarifaPlana($tarifaPlana = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TarifaPlana::valueIsValid($tarifaPlana)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TarifaPlana', is_array($tarifaPlana) ? implode(', ', $tarifaPlana) : var_export($tarifaPlana, true), implode(', ', \EnumType\TarifaPlana::getValidValues())), __LINE__);
        }
        $this->TarifaPlana = $tarifaPlana;
        return $this;
    }
    /**
     * Get IdClienteTarifaPlana value
     * @return string|null
     */
    public function getIdClienteTarifaPlana()
    {
        return $this->IdClienteTarifaPlana;
    }
    /**
     * Set IdClienteTarifaPlana value
     * @param string $idClienteTarifaPlana
     * @return \StructType\VATYPE
     */
    public function setIdClienteTarifaPlana($idClienteTarifaPlana = null)
    {
        // validation for constraint: string
        if (!is_null($idClienteTarifaPlana) && !is_string($idClienteTarifaPlana)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idClienteTarifaPlana, true), gettype($idClienteTarifaPlana)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($idClienteTarifaPlana) && mb_strlen($idClienteTarifaPlana) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($idClienteTarifaPlana)), __LINE__);
        }
        $this->IdClienteTarifaPlana = $idClienteTarifaPlana;
        return $this;
    }
    /**
     * Get IdOperacion value
     * @return string|null
     */
    public function getIdOperacion()
    {
        return $this->IdOperacion;
    }
    /**
     * Set IdOperacion value
     * @param string $idOperacion
     * @return \StructType\VATYPE
     */
    public function setIdOperacion($idOperacion = null)
    {
        // validation for constraint: string
        if (!is_null($idOperacion) && !is_string($idOperacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idOperacion, true), gettype($idOperacion)), __LINE__);
        }
        $this->IdOperacion = $idOperacion;
        return $this;
    }
}
