<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DATOSLOGISTICAINVERSATYPE StructType
 * @subpackage Structs
 */
class DATOSLOGISTICAINVERSATYPE extends AbstractStructBase
{
    /**
     * The DatosAdicRemitente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DIRECCIONADICIPCTYPE
     */
    public $DatosAdicRemitente;
    /**
     * The DatosAdicDestinatario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DIRECCIONADICIPCTYPE
     */
    public $DatosAdicDestinatario;
    /**
     * The DireccionPostal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DIRECCIONIPCTYPE
     */
    public $DireccionPostal;
    /**
     * The OficinaIntercambioDestino
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 6
     * - minOccurs: 0
     * - ref: xsd:OficinaIntercambioDestino
     * @var string
     */
    public $OficinaIntercambioDestino;
    /**
     * The ReferenciaClienteIPC
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 30
     * - minLength: 1
     * - minOccurs: 0
     * - ref: xsd:ReferenciaClienteIPC
     * @var string
     */
    public $ReferenciaClienteIPC;
    /**
     * The DireccionImportador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DIRECCIONIPCTYPE
     */
    public $DireccionImportador;
    /**
     * The ImportadorReferencia
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * - ref: xsd:ImportadorReferencia
     * @var string
     */
    public $ImportadorReferencia;
    /**
     * The ImportadorNumeroFax
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 20
     * - minOccurs: 0
     * - ref: xsd:ImportadorNumeroFax
     * @var string
     */
    public $ImportadorNumeroFax;
    /**
     * The DireccionRepresentanteAceptante
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DIRECCIONIPCTYPE
     */
    public $DireccionRepresentanteAceptante;
    /**
     * The RepresentanteAceptanteNumeroVAT
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * - ref: xsd:RepresentanteAceptanteNumeroVAT
     * @var string
     */
    public $RepresentanteAceptanteNumeroVAT;
    /**
     * The Aduana
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ADUANAIPCTYPE
     */
    public $Aduana;
    /**
     * The RazonDevolucion
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * - ref: xsd:RazonDevolucion
     * @var string
     */
    public $RazonDevolucion;
    /**
     * The Personalizados
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PERSONALIZADOSTYPE
     */
    public $Personalizados;
    /**
     * The Recogido
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * - ref: xsd:Recogido
     * @var string
     */
    public $Recogido;
    /**
     * Constructor method for DATOSLOGISTICAINVERSATYPE
     * @uses DATOSLOGISTICAINVERSATYPE::setDatosAdicRemitente()
     * @uses DATOSLOGISTICAINVERSATYPE::setDatosAdicDestinatario()
     * @uses DATOSLOGISTICAINVERSATYPE::setDireccionPostal()
     * @uses DATOSLOGISTICAINVERSATYPE::setOficinaIntercambioDestino()
     * @uses DATOSLOGISTICAINVERSATYPE::setReferenciaClienteIPC()
     * @uses DATOSLOGISTICAINVERSATYPE::setDireccionImportador()
     * @uses DATOSLOGISTICAINVERSATYPE::setImportadorReferencia()
     * @uses DATOSLOGISTICAINVERSATYPE::setImportadorNumeroFax()
     * @uses DATOSLOGISTICAINVERSATYPE::setDireccionRepresentanteAceptante()
     * @uses DATOSLOGISTICAINVERSATYPE::setRepresentanteAceptanteNumeroVAT()
     * @uses DATOSLOGISTICAINVERSATYPE::setAduana()
     * @uses DATOSLOGISTICAINVERSATYPE::setRazonDevolucion()
     * @uses DATOSLOGISTICAINVERSATYPE::setPersonalizados()
     * @uses DATOSLOGISTICAINVERSATYPE::setRecogido()
     * @param \StructType\DIRECCIONADICIPCTYPE $datosAdicRemitente
     * @param \StructType\DIRECCIONADICIPCTYPE $datosAdicDestinatario
     * @param \StructType\DIRECCIONIPCTYPE $direccionPostal
     * @param string $oficinaIntercambioDestino
     * @param string $referenciaClienteIPC
     * @param \StructType\DIRECCIONIPCTYPE $direccionImportador
     * @param string $importadorReferencia
     * @param string $importadorNumeroFax
     * @param \StructType\DIRECCIONIPCTYPE $direccionRepresentanteAceptante
     * @param string $representanteAceptanteNumeroVAT
     * @param \StructType\ADUANAIPCTYPE $aduana
     * @param string $razonDevolucion
     * @param \StructType\PERSONALIZADOSTYPE $personalizados
     * @param string $recogido
     */
    public function __construct(\StructType\DIRECCIONADICIPCTYPE $datosAdicRemitente = null, \StructType\DIRECCIONADICIPCTYPE $datosAdicDestinatario = null, \StructType\DIRECCIONIPCTYPE $direccionPostal = null, $oficinaIntercambioDestino = null, $referenciaClienteIPC = null, \StructType\DIRECCIONIPCTYPE $direccionImportador = null, $importadorReferencia = null, $importadorNumeroFax = null, \StructType\DIRECCIONIPCTYPE $direccionRepresentanteAceptante = null, $representanteAceptanteNumeroVAT = null, \StructType\ADUANAIPCTYPE $aduana = null, $razonDevolucion = null, \StructType\PERSONALIZADOSTYPE $personalizados = null, $recogido = null)
    {
        $this
            ->setDatosAdicRemitente($datosAdicRemitente)
            ->setDatosAdicDestinatario($datosAdicDestinatario)
            ->setDireccionPostal($direccionPostal)
            ->setOficinaIntercambioDestino($oficinaIntercambioDestino)
            ->setReferenciaClienteIPC($referenciaClienteIPC)
            ->setDireccionImportador($direccionImportador)
            ->setImportadorReferencia($importadorReferencia)
            ->setImportadorNumeroFax($importadorNumeroFax)
            ->setDireccionRepresentanteAceptante($direccionRepresentanteAceptante)
            ->setRepresentanteAceptanteNumeroVAT($representanteAceptanteNumeroVAT)
            ->setAduana($aduana)
            ->setRazonDevolucion($razonDevolucion)
            ->setPersonalizados($personalizados)
            ->setRecogido($recogido);
    }
    /**
     * Get DatosAdicRemitente value
     * @return \StructType\DIRECCIONADICIPCTYPE|null
     */
    public function getDatosAdicRemitente()
    {
        return $this->DatosAdicRemitente;
    }
    /**
     * Set DatosAdicRemitente value
     * @param \StructType\DIRECCIONADICIPCTYPE $datosAdicRemitente
     * @return \StructType\DATOSLOGISTICAINVERSATYPE
     */
    public function setDatosAdicRemitente(\StructType\DIRECCIONADICIPCTYPE $datosAdicRemitente = null)
    {
        $this->DatosAdicRemitente = $datosAdicRemitente;
        return $this;
    }
    /**
     * Get DatosAdicDestinatario value
     * @return \StructType\DIRECCIONADICIPCTYPE|null
     */
    public function getDatosAdicDestinatario()
    {
        return $this->DatosAdicDestinatario;
    }
    /**
     * Set DatosAdicDestinatario value
     * @param \StructType\DIRECCIONADICIPCTYPE $datosAdicDestinatario
     * @return \StructType\DATOSLOGISTICAINVERSATYPE
     */
    public function setDatosAdicDestinatario(\StructType\DIRECCIONADICIPCTYPE $datosAdicDestinatario = null)
    {
        $this->DatosAdicDestinatario = $datosAdicDestinatario;
        return $this;
    }
    /**
     * Get DireccionPostal value
     * @return \StructType\DIRECCIONIPCTYPE|null
     */
    public function getDireccionPostal()
    {
        return $this->DireccionPostal;
    }
    /**
     * Set DireccionPostal value
     * @param \StructType\DIRECCIONIPCTYPE $direccionPostal
     * @return \StructType\DATOSLOGISTICAINVERSATYPE
     */
    public function setDireccionPostal(\StructType\DIRECCIONIPCTYPE $direccionPostal = null)
    {
        $this->DireccionPostal = $direccionPostal;
        return $this;
    }
    /**
     * Get OficinaIntercambioDestino value
     * @return string|null
     */
    public function getOficinaIntercambioDestino()
    {
        return $this->OficinaIntercambioDestino;
    }
    /**
     * Set OficinaIntercambioDestino value
     * @param string $oficinaIntercambioDestino
     * @return \StructType\DATOSLOGISTICAINVERSATYPE
     */
    public function setOficinaIntercambioDestino($oficinaIntercambioDestino = null)
    {
        // validation for constraint: string
        if (!is_null($oficinaIntercambioDestino) && !is_string($oficinaIntercambioDestino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oficinaIntercambioDestino, true), gettype($oficinaIntercambioDestino)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($oficinaIntercambioDestino) && mb_strlen($oficinaIntercambioDestino) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($oficinaIntercambioDestino)), __LINE__);
        }
        $this->OficinaIntercambioDestino = $oficinaIntercambioDestino;
        return $this;
    }
    /**
     * Get ReferenciaClienteIPC value
     * @return string|null
     */
    public function getReferenciaClienteIPC()
    {
        return $this->ReferenciaClienteIPC;
    }
    /**
     * Set ReferenciaClienteIPC value
     * @param string $referenciaClienteIPC
     * @return \StructType\DATOSLOGISTICAINVERSATYPE
     */
    public function setReferenciaClienteIPC($referenciaClienteIPC = null)
    {
        // validation for constraint: string
        if (!is_null($referenciaClienteIPC) && !is_string($referenciaClienteIPC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenciaClienteIPC, true), gettype($referenciaClienteIPC)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($referenciaClienteIPC) && mb_strlen($referenciaClienteIPC) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($referenciaClienteIPC)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($referenciaClienteIPC) && mb_strlen($referenciaClienteIPC) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($referenciaClienteIPC)), __LINE__);
        }
        $this->ReferenciaClienteIPC = $referenciaClienteIPC;
        return $this;
    }
    /**
     * Get DireccionImportador value
     * @return \StructType\DIRECCIONIPCTYPE|null
     */
    public function getDireccionImportador()
    {
        return $this->DireccionImportador;
    }
    /**
     * Set DireccionImportador value
     * @param \StructType\DIRECCIONIPCTYPE $direccionImportador
     * @return \StructType\DATOSLOGISTICAINVERSATYPE
     */
    public function setDireccionImportador(\StructType\DIRECCIONIPCTYPE $direccionImportador = null)
    {
        $this->DireccionImportador = $direccionImportador;
        return $this;
    }
    /**
     * Get ImportadorReferencia value
     * @return string|null
     */
    public function getImportadorReferencia()
    {
        return $this->ImportadorReferencia;
    }
    /**
     * Set ImportadorReferencia value
     * @param string $importadorReferencia
     * @return \StructType\DATOSLOGISTICAINVERSATYPE
     */
    public function setImportadorReferencia($importadorReferencia = null)
    {
        // validation for constraint: string
        if (!is_null($importadorReferencia) && !is_string($importadorReferencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importadorReferencia, true), gettype($importadorReferencia)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($importadorReferencia) && mb_strlen($importadorReferencia) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($importadorReferencia)), __LINE__);
        }
        $this->ImportadorReferencia = $importadorReferencia;
        return $this;
    }
    /**
     * Get ImportadorNumeroFax value
     * @return string|null
     */
    public function getImportadorNumeroFax()
    {
        return $this->ImportadorNumeroFax;
    }
    /**
     * Set ImportadorNumeroFax value
     * @param string $importadorNumeroFax
     * @return \StructType\DATOSLOGISTICAINVERSATYPE
     */
    public function setImportadorNumeroFax($importadorNumeroFax = null)
    {
        // validation for constraint: string
        if (!is_null($importadorNumeroFax) && !is_string($importadorNumeroFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importadorNumeroFax, true), gettype($importadorNumeroFax)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($importadorNumeroFax) && mb_strlen($importadorNumeroFax) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($importadorNumeroFax)), __LINE__);
        }
        $this->ImportadorNumeroFax = $importadorNumeroFax;
        return $this;
    }
    /**
     * Get DireccionRepresentanteAceptante value
     * @return \StructType\DIRECCIONIPCTYPE|null
     */
    public function getDireccionRepresentanteAceptante()
    {
        return $this->DireccionRepresentanteAceptante;
    }
    /**
     * Set DireccionRepresentanteAceptante value
     * @param \StructType\DIRECCIONIPCTYPE $direccionRepresentanteAceptante
     * @return \StructType\DATOSLOGISTICAINVERSATYPE
     */
    public function setDireccionRepresentanteAceptante(\StructType\DIRECCIONIPCTYPE $direccionRepresentanteAceptante = null)
    {
        $this->DireccionRepresentanteAceptante = $direccionRepresentanteAceptante;
        return $this;
    }
    /**
     * Get RepresentanteAceptanteNumeroVAT value
     * @return string|null
     */
    public function getRepresentanteAceptanteNumeroVAT()
    {
        return $this->RepresentanteAceptanteNumeroVAT;
    }
    /**
     * Set RepresentanteAceptanteNumeroVAT value
     * @param string $representanteAceptanteNumeroVAT
     * @return \StructType\DATOSLOGISTICAINVERSATYPE
     */
    public function setRepresentanteAceptanteNumeroVAT($representanteAceptanteNumeroVAT = null)
    {
        // validation for constraint: string
        if (!is_null($representanteAceptanteNumeroVAT) && !is_string($representanteAceptanteNumeroVAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($representanteAceptanteNumeroVAT, true), gettype($representanteAceptanteNumeroVAT)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($representanteAceptanteNumeroVAT) && mb_strlen($representanteAceptanteNumeroVAT) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($representanteAceptanteNumeroVAT)), __LINE__);
        }
        $this->RepresentanteAceptanteNumeroVAT = $representanteAceptanteNumeroVAT;
        return $this;
    }
    /**
     * Get Aduana value
     * @return \StructType\ADUANAIPCTYPE|null
     */
    public function getAduana()
    {
        return $this->Aduana;
    }
    /**
     * Set Aduana value
     * @param \StructType\ADUANAIPCTYPE $aduana
     * @return \StructType\DATOSLOGISTICAINVERSATYPE
     */
    public function setAduana(\StructType\ADUANAIPCTYPE $aduana = null)
    {
        $this->Aduana = $aduana;
        return $this;
    }
    /**
     * Get RazonDevolucion value
     * @return string|null
     */
    public function getRazonDevolucion()
    {
        return $this->RazonDevolucion;
    }
    /**
     * Set RazonDevolucion value
     * @param string $razonDevolucion
     * @return \StructType\DATOSLOGISTICAINVERSATYPE
     */
    public function setRazonDevolucion($razonDevolucion = null)
    {
        // validation for constraint: string
        if (!is_null($razonDevolucion) && !is_string($razonDevolucion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($razonDevolucion, true), gettype($razonDevolucion)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($razonDevolucion) && mb_strlen($razonDevolucion) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($razonDevolucion)), __LINE__);
        }
        $this->RazonDevolucion = $razonDevolucion;
        return $this;
    }
    /**
     * Get Personalizados value
     * @return \StructType\PERSONALIZADOSTYPE|null
     */
    public function getPersonalizados()
    {
        return $this->Personalizados;
    }
    /**
     * Set Personalizados value
     * @param \StructType\PERSONALIZADOSTYPE $personalizados
     * @return \StructType\DATOSLOGISTICAINVERSATYPE
     */
    public function setPersonalizados(\StructType\PERSONALIZADOSTYPE $personalizados = null)
    {
        $this->Personalizados = $personalizados;
        return $this;
    }
    /**
     * Get Recogido value
     * @return string|null
     */
    public function getRecogido()
    {
        return $this->Recogido;
    }
    /**
     * Set Recogido value
     * @param string $recogido
     * @return \StructType\DATOSLOGISTICAINVERSATYPE
     */
    public function setRecogido($recogido = null)
    {
        // validation for constraint: string
        if (!is_null($recogido) && !is_string($recogido)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recogido, true), gettype($recogido)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($recogido) && mb_strlen($recogido) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($recogido)), __LINE__);
        }
        $this->Recogido = $recogido;
        return $this;
    }
}
