<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reexpedicion ServiceType
 * @subpackage Services
 */
class Reexpedicion extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Reexpedicion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PeticionReexpedicion $reexpedicionRequest
     * @return \StructType\RespuestaReexpedicion|bool
     */
    public function Reexpedicion(\StructType\PeticionReexpedicion $reexpedicionRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->Reexpedicion($reexpedicionRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RespuestaReexpedicion
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
