<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RespuestaSolicitudDocumentacionAduanera StructType
 * @subpackage Structs
 */
class RespuestaSolicitudDocumentacionAduanera extends AbstractStructBase
{
    /**
     * The Fichero
     * Meta information extracted from the WSDL
     * - ref: xsd:Fichero
     * @var string
     */
    public $Fichero;
    /**
     * The CodEnvio
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 23
     * - ref: xsd:CodEnvio
     * @var string
     */
    public $CodEnvio;
    /**
     * The Resultado
     * Meta information extracted from the WSDL
     * - ref: xsd:Resultado
     * @var string
     */
    public $Resultado;
    /**
     * The MotivoError
     * Meta information extracted from the WSDL
     * - ref: xsd:MotivoError
     * @var string
     */
    public $MotivoError;
    /**
     * The IdiomaErrores
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:IdiomaErrores
     * @var string
     */
    public $IdiomaErrores;
    /**
     * Constructor method for RespuestaSolicitudDocumentacionAduanera
     * @uses RespuestaSolicitudDocumentacionAduanera::setFichero()
     * @uses RespuestaSolicitudDocumentacionAduanera::setCodEnvio()
     * @uses RespuestaSolicitudDocumentacionAduanera::setResultado()
     * @uses RespuestaSolicitudDocumentacionAduanera::setMotivoError()
     * @uses RespuestaSolicitudDocumentacionAduanera::setIdiomaErrores()
     * @param string $fichero
     * @param string $codEnvio
     * @param string $resultado
     * @param string $motivoError
     * @param string $idiomaErrores
     */
    public function __construct($fichero = null, $codEnvio = null, $resultado = null, $motivoError = null, $idiomaErrores = null)
    {
        $this
            ->setFichero($fichero)
            ->setCodEnvio($codEnvio)
            ->setResultado($resultado)
            ->setMotivoError($motivoError)
            ->setIdiomaErrores($idiomaErrores);
    }
    /**
     * Get Fichero value
     * @return string|null
     */
    public function getFichero()
    {
        return $this->Fichero;
    }
    /**
     * Set Fichero value
     * @param string $fichero
     * @return \StructType\RespuestaSolicitudDocumentacionAduanera
     */
    public function setFichero($fichero = null)
    {
        // validation for constraint: string
        if (!is_null($fichero) && !is_string($fichero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fichero, true), gettype($fichero)), __LINE__);
        }
        $this->Fichero = $fichero;
        return $this;
    }
    /**
     * Get CodEnvio value
     * @return string|null
     */
    public function getCodEnvio()
    {
        return $this->CodEnvio;
    }
    /**
     * Set CodEnvio value
     * @param string $codEnvio
     * @return \StructType\RespuestaSolicitudDocumentacionAduanera
     */
    public function setCodEnvio($codEnvio = null)
    {
        // validation for constraint: string
        if (!is_null($codEnvio) && !is_string($codEnvio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codEnvio, true), gettype($codEnvio)), __LINE__);
        }
        // validation for constraint: maxLength(23)
        if (!is_null($codEnvio) && mb_strlen($codEnvio) > 23) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 23', mb_strlen($codEnvio)), __LINE__);
        }
        $this->CodEnvio = $codEnvio;
        return $this;
    }
    /**
     * Get Resultado value
     * @return string|null
     */
    public function getResultado()
    {
        return $this->Resultado;
    }
    /**
     * Set Resultado value
     * @uses \EnumType\Resultado::valueIsValid()
     * @uses \EnumType\Resultado::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultado
     * @return \StructType\RespuestaSolicitudDocumentacionAduanera
     */
    public function setResultado($resultado = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Resultado::valueIsValid($resultado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Resultado', is_array($resultado) ? implode(', ', $resultado) : var_export($resultado, true), implode(', ', \EnumType\Resultado::getValidValues())), __LINE__);
        }
        $this->Resultado = $resultado;
        return $this;
    }
    /**
     * Get MotivoError value
     * @return string|null
     */
    public function getMotivoError()
    {
        return $this->MotivoError;
    }
    /**
     * Set MotivoError value
     * @param string $motivoError
     * @return \StructType\RespuestaSolicitudDocumentacionAduanera
     */
    public function setMotivoError($motivoError = null)
    {
        // validation for constraint: string
        if (!is_null($motivoError) && !is_string($motivoError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motivoError, true), gettype($motivoError)), __LINE__);
        }
        $this->MotivoError = $motivoError;
        return $this;
    }
    /**
     * Get IdiomaErrores value
     * @return string|null
     */
    public function getIdiomaErrores()
    {
        return $this->IdiomaErrores;
    }
    /**
     * Set IdiomaErrores value
     * @param string $idiomaErrores
     * @return \StructType\RespuestaSolicitudDocumentacionAduanera
     */
    public function setIdiomaErrores($idiomaErrores = null)
    {
        // validation for constraint: string
        if (!is_null($idiomaErrores) && !is_string($idiomaErrores)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idiomaErrores, true), gettype($idiomaErrores)), __LINE__);
        }
        $this->IdiomaErrores = $idiomaErrores;
        return $this;
    }
}
