<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RespuestaPreRegistroCN StructType
 * @subpackage Structs
 */
class RespuestaPreRegistroCN extends AbstractStructBase
{
    /**
     * The FechaRespuesta
     * Meta information extracted from the WSDL
     * - ref: xsd:FechaRespuesta
     * @var string
     */
    public $FechaRespuesta;
    /**
     * The Resultado
     * Meta information extracted from the WSDL
     * - ref: xsd:Resultado
     * @var string
     */
    public $Resultado;
    /**
     * The TotalBultos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:TotalBultos
     * @var int
     */
    public $TotalBultos;
    /**
     * The BultosSimples
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:BultosSimples
     * @var \StructType\BultosSimples
     */
    public $BultosSimples;
    /**
     * The BultosError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:BultosError
     * @var \StructType\BultosError
     */
    public $BultosError;
    /**
     * The IdiomaErrores
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:IdiomaErrores
     * @var string
     */
    public $IdiomaErrores;
    /**
     * Constructor method for RespuestaPreRegistroCN
     * @uses RespuestaPreRegistroCN::setFechaRespuesta()
     * @uses RespuestaPreRegistroCN::setResultado()
     * @uses RespuestaPreRegistroCN::setTotalBultos()
     * @uses RespuestaPreRegistroCN::setBultosSimples()
     * @uses RespuestaPreRegistroCN::setBultosError()
     * @uses RespuestaPreRegistroCN::setIdiomaErrores()
     * @param string $fechaRespuesta
     * @param string $resultado
     * @param int $totalBultos
     * @param \StructType\BultosSimples $bultosSimples
     * @param \StructType\BultosError $bultosError
     * @param string $idiomaErrores
     */
    public function __construct($fechaRespuesta = null, $resultado = null, $totalBultos = null, \StructType\BultosSimples $bultosSimples = null, \StructType\BultosError $bultosError = null, $idiomaErrores = null)
    {
        $this
            ->setFechaRespuesta($fechaRespuesta)
            ->setResultado($resultado)
            ->setTotalBultos($totalBultos)
            ->setBultosSimples($bultosSimples)
            ->setBultosError($bultosError)
            ->setIdiomaErrores($idiomaErrores);
    }
    /**
     * Get FechaRespuesta value
     * @return string|null
     */
    public function getFechaRespuesta()
    {
        return $this->FechaRespuesta;
    }
    /**
     * Set FechaRespuesta value
     * @param string $fechaRespuesta
     * @return \StructType\RespuestaPreRegistroCN
     */
    public function setFechaRespuesta($fechaRespuesta = null)
    {
        // validation for constraint: string
        if (!is_null($fechaRespuesta) && !is_string($fechaRespuesta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaRespuesta, true), gettype($fechaRespuesta)), __LINE__);
        }
        $this->FechaRespuesta = $fechaRespuesta;
        return $this;
    }
    /**
     * Get Resultado value
     * @return string|null
     */
    public function getResultado()
    {
        return $this->Resultado;
    }
    /**
     * Set Resultado value
     * @uses \EnumType\Resultado::valueIsValid()
     * @uses \EnumType\Resultado::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultado
     * @return \StructType\RespuestaPreRegistroCN
     */
    public function setResultado($resultado = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Resultado::valueIsValid($resultado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Resultado', is_array($resultado) ? implode(', ', $resultado) : var_export($resultado, true), implode(', ', \EnumType\Resultado::getValidValues())), __LINE__);
        }
        $this->Resultado = $resultado;
        return $this;
    }
    /**
     * Get TotalBultos value
     * @return int|null
     */
    public function getTotalBultos()
    {
        return $this->TotalBultos;
    }
    /**
     * Set TotalBultos value
     * @param int $totalBultos
     * @return \StructType\RespuestaPreRegistroCN
     */
    public function setTotalBultos($totalBultos = null)
    {
        // validation for constraint: int
        if (!is_null($totalBultos) && !(is_int($totalBultos) || ctype_digit($totalBultos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalBultos, true), gettype($totalBultos)), __LINE__);
        }
        $this->TotalBultos = $totalBultos;
        return $this;
    }
    /**
     * Get BultosSimples value
     * @return \StructType\BultosSimples|null
     */
    public function getBultosSimples()
    {
        return $this->BultosSimples;
    }
    /**
     * Set BultosSimples value
     * @param \StructType\BultosSimples $bultosSimples
     * @return \StructType\RespuestaPreRegistroCN
     */
    public function setBultosSimples(\StructType\BultosSimples $bultosSimples = null)
    {
        $this->BultosSimples = $bultosSimples;
        return $this;
    }
    /**
     * Get BultosError value
     * @return \StructType\BultosError|null
     */
    public function getBultosError()
    {
        return $this->BultosError;
    }
    /**
     * Set BultosError value
     * @param \StructType\BultosError $bultosError
     * @return \StructType\RespuestaPreRegistroCN
     */
    public function setBultosError(\StructType\BultosError $bultosError = null)
    {
        $this->BultosError = $bultosError;
        return $this;
    }
    /**
     * Get IdiomaErrores value
     * @return string|null
     */
    public function getIdiomaErrores()
    {
        return $this->IdiomaErrores;
    }
    /**
     * Set IdiomaErrores value
     * @param string $idiomaErrores
     * @return \StructType\RespuestaPreRegistroCN
     */
    public function setIdiomaErrores($idiomaErrores = null)
    {
        // validation for constraint: string
        if (!is_null($idiomaErrores) && !is_string($idiomaErrores)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idiomaErrores, true), gettype($idiomaErrores)), __LINE__);
        }
        $this->IdiomaErrores = $idiomaErrores;
        return $this;
    }
}
