<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ADUANAIPCTYPE StructType
 * @subpackage Structs
 */
class ADUANAIPCTYPE extends AbstractStructBase
{
    /**
     * The Moneda
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Moneda;
    /**
     * The PiezasDelContenido
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PIEZASDELCONTENIDOTYPE
     */
    public $PiezasDelContenido;
    /**
     * The ItemsOrginales
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ITEMSORIGINALESTYPE
     */
    public $ItemsOrginales;
    /**
     * The DocumentosAdjuntos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DOCUMENTOSADJUNTOSTYPE
     */
    public $DocumentosAdjuntos;
    /**
     * The FacturasOriginales
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FACTURASORIGINALESTYPE
     */
    public $FacturasOriginales;
    /**
     * The NaturalezaCodigoTransaccion
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $NaturalezaCodigoTransaccion;
    /**
     * The Comentarios
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 150
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comentarios;
    /**
     * The Incoterm
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - minOccurs: 0
     * @var string
     */
    public $Incoterm;
    /**
     * Constructor method for ADUANAIPCTYPE
     * @uses ADUANAIPCTYPE::setMoneda()
     * @uses ADUANAIPCTYPE::setPiezasDelContenido()
     * @uses ADUANAIPCTYPE::setItemsOrginales()
     * @uses ADUANAIPCTYPE::setDocumentosAdjuntos()
     * @uses ADUANAIPCTYPE::setFacturasOriginales()
     * @uses ADUANAIPCTYPE::setNaturalezaCodigoTransaccion()
     * @uses ADUANAIPCTYPE::setComentarios()
     * @uses ADUANAIPCTYPE::setIncoterm()
     * @param string $moneda
     * @param \StructType\PIEZASDELCONTENIDOTYPE $piezasDelContenido
     * @param \StructType\ITEMSORIGINALESTYPE $itemsOrginales
     * @param \StructType\DOCUMENTOSADJUNTOSTYPE $documentosAdjuntos
     * @param \StructType\FACTURASORIGINALESTYPE $facturasOriginales
     * @param string $naturalezaCodigoTransaccion
     * @param string $comentarios
     * @param string $incoterm
     */
    public function __construct($moneda = null, \StructType\PIEZASDELCONTENIDOTYPE $piezasDelContenido = null, \StructType\ITEMSORIGINALESTYPE $itemsOrginales = null, \StructType\DOCUMENTOSADJUNTOSTYPE $documentosAdjuntos = null, \StructType\FACTURASORIGINALESTYPE $facturasOriginales = null, $naturalezaCodigoTransaccion = null, $comentarios = null, $incoterm = null)
    {
        $this
            ->setMoneda($moneda)
            ->setPiezasDelContenido($piezasDelContenido)
            ->setItemsOrginales($itemsOrginales)
            ->setDocumentosAdjuntos($documentosAdjuntos)
            ->setFacturasOriginales($facturasOriginales)
            ->setNaturalezaCodigoTransaccion($naturalezaCodigoTransaccion)
            ->setComentarios($comentarios)
            ->setIncoterm($incoterm);
    }
    /**
     * Get Moneda value
     * @return string|null
     */
    public function getMoneda()
    {
        return $this->Moneda;
    }
    /**
     * Set Moneda value
     * @uses \EnumType\Moneda::valueIsValid()
     * @uses \EnumType\Moneda::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $moneda
     * @return \StructType\ADUANAIPCTYPE
     */
    public function setMoneda($moneda = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Moneda::valueIsValid($moneda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Moneda', is_array($moneda) ? implode(', ', $moneda) : var_export($moneda, true), implode(', ', \EnumType\Moneda::getValidValues())), __LINE__);
        }
        $this->Moneda = $moneda;
        return $this;
    }
    /**
     * Get PiezasDelContenido value
     * @return \StructType\PIEZASDELCONTENIDOTYPE|null
     */
    public function getPiezasDelContenido()
    {
        return $this->PiezasDelContenido;
    }
    /**
     * Set PiezasDelContenido value
     * @param \StructType\PIEZASDELCONTENIDOTYPE $piezasDelContenido
     * @return \StructType\ADUANAIPCTYPE
     */
    public function setPiezasDelContenido(\StructType\PIEZASDELCONTENIDOTYPE $piezasDelContenido = null)
    {
        $this->PiezasDelContenido = $piezasDelContenido;
        return $this;
    }
    /**
     * Get ItemsOrginales value
     * @return \StructType\ITEMSORIGINALESTYPE|null
     */
    public function getItemsOrginales()
    {
        return $this->ItemsOrginales;
    }
    /**
     * Set ItemsOrginales value
     * @param \StructType\ITEMSORIGINALESTYPE $itemsOrginales
     * @return \StructType\ADUANAIPCTYPE
     */
    public function setItemsOrginales(\StructType\ITEMSORIGINALESTYPE $itemsOrginales = null)
    {
        $this->ItemsOrginales = $itemsOrginales;
        return $this;
    }
    /**
     * Get DocumentosAdjuntos value
     * @return \StructType\DOCUMENTOSADJUNTOSTYPE|null
     */
    public function getDocumentosAdjuntos()
    {
        return $this->DocumentosAdjuntos;
    }
    /**
     * Set DocumentosAdjuntos value
     * @param \StructType\DOCUMENTOSADJUNTOSTYPE $documentosAdjuntos
     * @return \StructType\ADUANAIPCTYPE
     */
    public function setDocumentosAdjuntos(\StructType\DOCUMENTOSADJUNTOSTYPE $documentosAdjuntos = null)
    {
        $this->DocumentosAdjuntos = $documentosAdjuntos;
        return $this;
    }
    /**
     * Get FacturasOriginales value
     * @return \StructType\FACTURASORIGINALESTYPE|null
     */
    public function getFacturasOriginales()
    {
        return $this->FacturasOriginales;
    }
    /**
     * Set FacturasOriginales value
     * @param \StructType\FACTURASORIGINALESTYPE $facturasOriginales
     * @return \StructType\ADUANAIPCTYPE
     */
    public function setFacturasOriginales(\StructType\FACTURASORIGINALESTYPE $facturasOriginales = null)
    {
        $this->FacturasOriginales = $facturasOriginales;
        return $this;
    }
    /**
     * Get NaturalezaCodigoTransaccion value
     * @return string|null
     */
    public function getNaturalezaCodigoTransaccion()
    {
        return $this->NaturalezaCodigoTransaccion;
    }
    /**
     * Set NaturalezaCodigoTransaccion value
     * @param string $naturalezaCodigoTransaccion
     * @return \StructType\ADUANAIPCTYPE
     */
    public function setNaturalezaCodigoTransaccion($naturalezaCodigoTransaccion = null)
    {
        // validation for constraint: string
        if (!is_null($naturalezaCodigoTransaccion) && !is_string($naturalezaCodigoTransaccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naturalezaCodigoTransaccion, true), gettype($naturalezaCodigoTransaccion)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($naturalezaCodigoTransaccion) && mb_strlen($naturalezaCodigoTransaccion) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($naturalezaCodigoTransaccion)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($naturalezaCodigoTransaccion) && mb_strlen($naturalezaCodigoTransaccion) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($naturalezaCodigoTransaccion)), __LINE__);
        }
        $this->NaturalezaCodigoTransaccion = $naturalezaCodigoTransaccion;
        return $this;
    }
    /**
     * Get Comentarios value
     * @return string|null
     */
    public function getComentarios()
    {
        return $this->Comentarios;
    }
    /**
     * Set Comentarios value
     * @param string $comentarios
     * @return \StructType\ADUANAIPCTYPE
     */
    public function setComentarios($comentarios = null)
    {
        // validation for constraint: string
        if (!is_null($comentarios) && !is_string($comentarios)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comentarios, true), gettype($comentarios)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($comentarios) && mb_strlen($comentarios) > 150) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen($comentarios)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($comentarios) && mb_strlen($comentarios) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($comentarios)), __LINE__);
        }
        $this->Comentarios = $comentarios;
        return $this;
    }
    /**
     * Get Incoterm value
     * @return string|null
     */
    public function getIncoterm()
    {
        return $this->Incoterm;
    }
    /**
     * Set Incoterm value
     * @param string $incoterm
     * @return \StructType\ADUANAIPCTYPE
     */
    public function setIncoterm($incoterm = null)
    {
        // validation for constraint: string
        if (!is_null($incoterm) && !is_string($incoterm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incoterm, true), gettype($incoterm)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($incoterm) && mb_strlen($incoterm) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($incoterm)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($incoterm) && mb_strlen($incoterm) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($incoterm)), __LINE__);
        }
        $this->Incoterm = $incoterm;
        return $this;
    }
}
