<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Validar ServiceType
 * @subpackage Services
 */
class Validar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ValidarDatosOp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ValidarDatos $validarDatosRequest
     * @return \StructType\RespuestaValidarDatos|bool
     */
    public function ValidarDatosOp(\StructType\ValidarDatos $validarDatosRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidarDatosOp($validarDatosRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RespuestaValidarDatos
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
