<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Baja ServiceType
 * @subpackage Services
 */
class Baja extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BajaOp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PeticionBaja $bajaRequest
     * @return \StructType\RespuestaBaja|bool
     */
    public function BajaOp(\StructType\PeticionBaja $bajaRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->BajaOp($bajaRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RespuestaBaja
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
