<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RespuestaSolicitudEtiquetaRefCli StructType
 * @subpackage Structs
 */
class RespuestaSolicitudEtiquetaRefCli extends AbstractStructBase
{
    /**
     * The CodExpedicion
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * - ref: xsd:CodExpedicion
     * @var string
     */
    public $CodExpedicion;
    /**
     * The FechaRespuesta
     * Meta information extracted from the WSDL
     * - ref: xsd:FechaRespuesta
     * @var string
     */
    public $FechaRespuesta;
    /**
     * The Resultado
     * Meta information extracted from the WSDL
     * - ref: xsd:Resultado
     * @var string
     */
    public $Resultado;
    /**
     * The TotalBultos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:TotalBultos
     * @var int
     */
    public $TotalBultos;
    /**
     * The Bulto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:Bulto
     * @var \StructType\DATOSBULTOTYPE
     */
    public $Bulto;
    /**
     * The BultoError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:BultoError
     * @var \StructType\DATOSBULTOERRORTYPE
     */
    public $BultoError;
    /**
     * The IdiomaErrores
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:IdiomaErrores
     * @var string
     */
    public $IdiomaErrores;
    /**
     * Constructor method for RespuestaSolicitudEtiquetaRefCli
     * @uses RespuestaSolicitudEtiquetaRefCli::setCodExpedicion()
     * @uses RespuestaSolicitudEtiquetaRefCli::setFechaRespuesta()
     * @uses RespuestaSolicitudEtiquetaRefCli::setResultado()
     * @uses RespuestaSolicitudEtiquetaRefCli::setTotalBultos()
     * @uses RespuestaSolicitudEtiquetaRefCli::setBulto()
     * @uses RespuestaSolicitudEtiquetaRefCli::setBultoError()
     * @uses RespuestaSolicitudEtiquetaRefCli::setIdiomaErrores()
     * @param string $codExpedicion
     * @param string $fechaRespuesta
     * @param string $resultado
     * @param int $totalBultos
     * @param \StructType\DATOSBULTOTYPE $bulto
     * @param \StructType\DATOSBULTOERRORTYPE $bultoError
     * @param string $idiomaErrores
     */
    public function __construct($codExpedicion = null, $fechaRespuesta = null, $resultado = null, $totalBultos = null, \StructType\DATOSBULTOTYPE $bulto = null, \StructType\DATOSBULTOERRORTYPE $bultoError = null, $idiomaErrores = null)
    {
        $this
            ->setCodExpedicion($codExpedicion)
            ->setFechaRespuesta($fechaRespuesta)
            ->setResultado($resultado)
            ->setTotalBultos($totalBultos)
            ->setBulto($bulto)
            ->setBultoError($bultoError)
            ->setIdiomaErrores($idiomaErrores);
    }
    /**
     * Get CodExpedicion value
     * @return string|null
     */
    public function getCodExpedicion()
    {
        return $this->CodExpedicion;
    }
    /**
     * Set CodExpedicion value
     * @param string $codExpedicion
     * @return \StructType\RespuestaSolicitudEtiquetaRefCli
     */
    public function setCodExpedicion($codExpedicion = null)
    {
        // validation for constraint: string
        if (!is_null($codExpedicion) && !is_string($codExpedicion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codExpedicion, true), gettype($codExpedicion)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($codExpedicion) && mb_strlen($codExpedicion) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($codExpedicion)), __LINE__);
        }
        $this->CodExpedicion = $codExpedicion;
        return $this;
    }
    /**
     * Get FechaRespuesta value
     * @return string|null
     */
    public function getFechaRespuesta()
    {
        return $this->FechaRespuesta;
    }
    /**
     * Set FechaRespuesta value
     * @param string $fechaRespuesta
     * @return \StructType\RespuestaSolicitudEtiquetaRefCli
     */
    public function setFechaRespuesta($fechaRespuesta = null)
    {
        // validation for constraint: string
        if (!is_null($fechaRespuesta) && !is_string($fechaRespuesta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaRespuesta, true), gettype($fechaRespuesta)), __LINE__);
        }
        $this->FechaRespuesta = $fechaRespuesta;
        return $this;
    }
    /**
     * Get Resultado value
     * @return string|null
     */
    public function getResultado()
    {
        return $this->Resultado;
    }
    /**
     * Set Resultado value
     * @uses \EnumType\Resultado::valueIsValid()
     * @uses \EnumType\Resultado::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultado
     * @return \StructType\RespuestaSolicitudEtiquetaRefCli
     */
    public function setResultado($resultado = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Resultado::valueIsValid($resultado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Resultado', is_array($resultado) ? implode(', ', $resultado) : var_export($resultado, true), implode(', ', \EnumType\Resultado::getValidValues())), __LINE__);
        }
        $this->Resultado = $resultado;
        return $this;
    }
    /**
     * Get TotalBultos value
     * @return int|null
     */
    public function getTotalBultos()
    {
        return $this->TotalBultos;
    }
    /**
     * Set TotalBultos value
     * @param int $totalBultos
     * @return \StructType\RespuestaSolicitudEtiquetaRefCli
     */
    public function setTotalBultos($totalBultos = null)
    {
        // validation for constraint: int
        if (!is_null($totalBultos) && !(is_int($totalBultos) || ctype_digit($totalBultos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalBultos, true), gettype($totalBultos)), __LINE__);
        }
        $this->TotalBultos = $totalBultos;
        return $this;
    }
    /**
     * Get Bulto value
     * @return \StructType\DATOSBULTOTYPE|null
     */
    public function getBulto()
    {
        return $this->Bulto;
    }
    /**
     * Set Bulto value
     * @param \StructType\DATOSBULTOTYPE $bulto
     * @return \StructType\RespuestaSolicitudEtiquetaRefCli
     */
    public function setBulto(\StructType\DATOSBULTOTYPE $bulto = null)
    {
        $this->Bulto = $bulto;
        return $this;
    }
    /**
     * Get BultoError value
     * @return \StructType\DATOSBULTOERRORTYPE|null
     */
    public function getBultoError()
    {
        return $this->BultoError;
    }
    /**
     * Set BultoError value
     * @param \StructType\DATOSBULTOERRORTYPE $bultoError
     * @return \StructType\RespuestaSolicitudEtiquetaRefCli
     */
    public function setBultoError(\StructType\DATOSBULTOERRORTYPE $bultoError = null)
    {
        $this->BultoError = $bultoError;
        return $this;
    }
    /**
     * Get IdiomaErrores value
     * @return string|null
     */
    public function getIdiomaErrores()
    {
        return $this->IdiomaErrores;
    }
    /**
     * Set IdiomaErrores value
     * @param string $idiomaErrores
     * @return \StructType\RespuestaSolicitudEtiquetaRefCli
     */
    public function setIdiomaErrores($idiomaErrores = null)
    {
        // validation for constraint: string
        if (!is_null($idiomaErrores) && !is_string($idiomaErrores)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idiomaErrores, true), gettype($idiomaErrores)), __LINE__);
        }
        $this->IdiomaErrores = $idiomaErrores;
        return $this;
    }
}
