<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RespuestaCalculaTarifa StructType
 * @subpackage Structs
 */
class RespuestaCalculaTarifa extends AbstractStructBase
{
    /**
     * The FechaRespuesta
     * Meta information extracted from the WSDL
     * - ref: xsd:FechaRespuesta
     * @var string
     */
    public $FechaRespuesta;
    /**
     * The Resultado
     * Meta information extracted from the WSDL
     * - ref: xsd:Resultado
     * @var string
     */
    public $Resultado;
    /**
     * The Tarifa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:Tarifa
     * @var string
     */
    public $Tarifa;
    /**
     * The ErroresValidacion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:ErroresValidacion
     * @var \StructType\LISTAERRORESVALIDACIONTYPE
     */
    public $ErroresValidacion;
    /**
     * The IdiomaErrores
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:IdiomaErrores
     * @var string
     */
    public $IdiomaErrores;
    /**
     * Constructor method for RespuestaCalculaTarifa
     * @uses RespuestaCalculaTarifa::setFechaRespuesta()
     * @uses RespuestaCalculaTarifa::setResultado()
     * @uses RespuestaCalculaTarifa::setTarifa()
     * @uses RespuestaCalculaTarifa::setErroresValidacion()
     * @uses RespuestaCalculaTarifa::setIdiomaErrores()
     * @param string $fechaRespuesta
     * @param string $resultado
     * @param string $tarifa
     * @param \StructType\LISTAERRORESVALIDACIONTYPE $erroresValidacion
     * @param string $idiomaErrores
     */
    public function __construct($fechaRespuesta = null, $resultado = null, $tarifa = null, \StructType\LISTAERRORESVALIDACIONTYPE $erroresValidacion = null, $idiomaErrores = null)
    {
        $this
            ->setFechaRespuesta($fechaRespuesta)
            ->setResultado($resultado)
            ->setTarifa($tarifa)
            ->setErroresValidacion($erroresValidacion)
            ->setIdiomaErrores($idiomaErrores);
    }
    /**
     * Get FechaRespuesta value
     * @return string|null
     */
    public function getFechaRespuesta()
    {
        return $this->FechaRespuesta;
    }
    /**
     * Set FechaRespuesta value
     * @param string $fechaRespuesta
     * @return \StructType\RespuestaCalculaTarifa
     */
    public function setFechaRespuesta($fechaRespuesta = null)
    {
        // validation for constraint: string
        if (!is_null($fechaRespuesta) && !is_string($fechaRespuesta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaRespuesta, true), gettype($fechaRespuesta)), __LINE__);
        }
        $this->FechaRespuesta = $fechaRespuesta;
        return $this;
    }
    /**
     * Get Resultado value
     * @return string|null
     */
    public function getResultado()
    {
        return $this->Resultado;
    }
    /**
     * Set Resultado value
     * @uses \EnumType\Resultado::valueIsValid()
     * @uses \EnumType\Resultado::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultado
     * @return \StructType\RespuestaCalculaTarifa
     */
    public function setResultado($resultado = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Resultado::valueIsValid($resultado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Resultado', is_array($resultado) ? implode(', ', $resultado) : var_export($resultado, true), implode(', ', \EnumType\Resultado::getValidValues())), __LINE__);
        }
        $this->Resultado = $resultado;
        return $this;
    }
    /**
     * Get Tarifa value
     * @return string|null
     */
    public function getTarifa()
    {
        return $this->Tarifa;
    }
    /**
     * Set Tarifa value
     * @param string $tarifa
     * @return \StructType\RespuestaCalculaTarifa
     */
    public function setTarifa($tarifa = null)
    {
        // validation for constraint: string
        if (!is_null($tarifa) && !is_string($tarifa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarifa, true), gettype($tarifa)), __LINE__);
        }
        $this->Tarifa = $tarifa;
        return $this;
    }
    /**
     * Get ErroresValidacion value
     * @return \StructType\LISTAERRORESVALIDACIONTYPE|null
     */
    public function getErroresValidacion()
    {
        return $this->ErroresValidacion;
    }
    /**
     * Set ErroresValidacion value
     * @param \StructType\LISTAERRORESVALIDACIONTYPE $erroresValidacion
     * @return \StructType\RespuestaCalculaTarifa
     */
    public function setErroresValidacion(\StructType\LISTAERRORESVALIDACIONTYPE $erroresValidacion = null)
    {
        $this->ErroresValidacion = $erroresValidacion;
        return $this;
    }
    /**
     * Get IdiomaErrores value
     * @return string|null
     */
    public function getIdiomaErrores()
    {
        return $this->IdiomaErrores;
    }
    /**
     * Set IdiomaErrores value
     * @param string $idiomaErrores
     * @return \StructType\RespuestaCalculaTarifa
     */
    public function setIdiomaErrores($idiomaErrores = null)
    {
        // validation for constraint: string
        if (!is_null($idiomaErrores) && !is_string($idiomaErrores)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idiomaErrores, true), gettype($idiomaErrores)), __LINE__);
        }
        $this->IdiomaErrores = $idiomaErrores;
        return $this;
    }
}
