<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DATOSETIQUETAXMLTYPE StructType
 * @subpackage Structs
 */
class DATOSETIQUETAXMLTYPE extends AbstractStructBase
{
    /**
     * The RemitenteEtiqueta
     * Meta information extracted from the WSDL
     * - ref: xsd:RemitenteEtiqueta
     * @var \StructType\DATOSREMITENTEETIQUETATYPE
     */
    public $RemitenteEtiqueta;
    /**
     * The DestinatarioEtiqueta
     * Meta information extracted from the WSDL
     * - ref: xsd:DestinatarioEtiqueta
     * @var \StructType\DATOSDESTINATARIOETIQUETATYPE
     */
    public $DestinatarioEtiqueta;
    /**
     * The Referencia
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * - ref: xsd:Referencia
     * @var string
     */
    public $Referencia;
    /**
     * The PesoReal
     * Meta information extracted from the WSDL
     * - ref: xsd:PesoReal
     * @var string
     */
    public $PesoReal;
    /**
     * The PesoVol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:PesoVol
     * @var string
     */
    public $PesoVol;
    /**
     * The Observaciones
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 90
     * - minOccurs: 0
     * - ref: xsd:Observaciones
     * @var string
     */
    public $Observaciones;
    /**
     * The FechaEtiquetado
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:FechaEtiquetado
     * @var string
     */
    public $FechaEtiquetado;
    /**
     * The CodigoBarras
     * Meta information extracted from the WSDL
     * - ref: xsd:CodigoBarras
     * @var \StructType\FICHEROADJUNTOTYPE
     */
    public $CodigoBarras;
    /**
     * The InstruccionesDevolucion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:InstruccionesDevolucion
     * @var string
     */
    public $InstruccionesDevolucion;
    /**
     * The VA
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: xsd:VA
     * @var \StructType\VAETIQUETATYPE
     */
    public $VA;
    /**
     * Constructor method for DATOSETIQUETAXMLTYPE
     * @uses DATOSETIQUETAXMLTYPE::setRemitenteEtiqueta()
     * @uses DATOSETIQUETAXMLTYPE::setDestinatarioEtiqueta()
     * @uses DATOSETIQUETAXMLTYPE::setReferencia()
     * @uses DATOSETIQUETAXMLTYPE::setPesoReal()
     * @uses DATOSETIQUETAXMLTYPE::setPesoVol()
     * @uses DATOSETIQUETAXMLTYPE::setObservaciones()
     * @uses DATOSETIQUETAXMLTYPE::setFechaEtiquetado()
     * @uses DATOSETIQUETAXMLTYPE::setCodigoBarras()
     * @uses DATOSETIQUETAXMLTYPE::setInstruccionesDevolucion()
     * @uses DATOSETIQUETAXMLTYPE::setVA()
     * @param \StructType\DATOSREMITENTEETIQUETATYPE $remitenteEtiqueta
     * @param \StructType\DATOSDESTINATARIOETIQUETATYPE $destinatarioEtiqueta
     * @param string $referencia
     * @param string $pesoReal
     * @param string $pesoVol
     * @param string $observaciones
     * @param string $fechaEtiquetado
     * @param \StructType\FICHEROADJUNTOTYPE $codigoBarras
     * @param string $instruccionesDevolucion
     * @param \StructType\VAETIQUETATYPE $vA
     */
    public function __construct(\StructType\DATOSREMITENTEETIQUETATYPE $remitenteEtiqueta = null, \StructType\DATOSDESTINATARIOETIQUETATYPE $destinatarioEtiqueta = null, $referencia = null, $pesoReal = null, $pesoVol = null, $observaciones = null, $fechaEtiquetado = null, \StructType\FICHEROADJUNTOTYPE $codigoBarras = null, $instruccionesDevolucion = null, \StructType\VAETIQUETATYPE $vA = null)
    {
        $this
            ->setRemitenteEtiqueta($remitenteEtiqueta)
            ->setDestinatarioEtiqueta($destinatarioEtiqueta)
            ->setReferencia($referencia)
            ->setPesoReal($pesoReal)
            ->setPesoVol($pesoVol)
            ->setObservaciones($observaciones)
            ->setFechaEtiquetado($fechaEtiquetado)
            ->setCodigoBarras($codigoBarras)
            ->setInstruccionesDevolucion($instruccionesDevolucion)
            ->setVA($vA);
    }
    /**
     * Get RemitenteEtiqueta value
     * @return \StructType\DATOSREMITENTEETIQUETATYPE|null
     */
    public function getRemitenteEtiqueta()
    {
        return $this->RemitenteEtiqueta;
    }
    /**
     * Set RemitenteEtiqueta value
     * @param \StructType\DATOSREMITENTEETIQUETATYPE $remitenteEtiqueta
     * @return \StructType\DATOSETIQUETAXMLTYPE
     */
    public function setRemitenteEtiqueta(\StructType\DATOSREMITENTEETIQUETATYPE $remitenteEtiqueta = null)
    {
        $this->RemitenteEtiqueta = $remitenteEtiqueta;
        return $this;
    }
    /**
     * Get DestinatarioEtiqueta value
     * @return \StructType\DATOSDESTINATARIOETIQUETATYPE|null
     */
    public function getDestinatarioEtiqueta()
    {
        return $this->DestinatarioEtiqueta;
    }
    /**
     * Set DestinatarioEtiqueta value
     * @param \StructType\DATOSDESTINATARIOETIQUETATYPE $destinatarioEtiqueta
     * @return \StructType\DATOSETIQUETAXMLTYPE
     */
    public function setDestinatarioEtiqueta(\StructType\DATOSDESTINATARIOETIQUETATYPE $destinatarioEtiqueta = null)
    {
        $this->DestinatarioEtiqueta = $destinatarioEtiqueta;
        return $this;
    }
    /**
     * Get Referencia value
     * @return string|null
     */
    public function getReferencia()
    {
        return $this->Referencia;
    }
    /**
     * Set Referencia value
     * @param string $referencia
     * @return \StructType\DATOSETIQUETAXMLTYPE
     */
    public function setReferencia($referencia = null)
    {
        // validation for constraint: string
        if (!is_null($referencia) && !is_string($referencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencia, true), gettype($referencia)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($referencia) && mb_strlen($referencia) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($referencia)), __LINE__);
        }
        $this->Referencia = $referencia;
        return $this;
    }
    /**
     * Get PesoReal value
     * @return string|null
     */
    public function getPesoReal()
    {
        return $this->PesoReal;
    }
    /**
     * Set PesoReal value
     * @param string $pesoReal
     * @return \StructType\DATOSETIQUETAXMLTYPE
     */
    public function setPesoReal($pesoReal = null)
    {
        // validation for constraint: string
        if (!is_null($pesoReal) && !is_string($pesoReal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pesoReal, true), gettype($pesoReal)), __LINE__);
        }
        $this->PesoReal = $pesoReal;
        return $this;
    }
    /**
     * Get PesoVol value
     * @return string|null
     */
    public function getPesoVol()
    {
        return $this->PesoVol;
    }
    /**
     * Set PesoVol value
     * @param string $pesoVol
     * @return \StructType\DATOSETIQUETAXMLTYPE
     */
    public function setPesoVol($pesoVol = null)
    {
        // validation for constraint: string
        if (!is_null($pesoVol) && !is_string($pesoVol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pesoVol, true), gettype($pesoVol)), __LINE__);
        }
        $this->PesoVol = $pesoVol;
        return $this;
    }
    /**
     * Get Observaciones value
     * @return string|null
     */
    public function getObservaciones()
    {
        return $this->Observaciones;
    }
    /**
     * Set Observaciones value
     * @param string $observaciones
     * @return \StructType\DATOSETIQUETAXMLTYPE
     */
    public function setObservaciones($observaciones = null)
    {
        // validation for constraint: string
        if (!is_null($observaciones) && !is_string($observaciones)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observaciones, true), gettype($observaciones)), __LINE__);
        }
        // validation for constraint: maxLength(90)
        if (!is_null($observaciones) && mb_strlen($observaciones) > 90) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 90', mb_strlen($observaciones)), __LINE__);
        }
        $this->Observaciones = $observaciones;
        return $this;
    }
    /**
     * Get FechaEtiquetado value
     * @return string|null
     */
    public function getFechaEtiquetado()
    {
        return $this->FechaEtiquetado;
    }
    /**
     * Set FechaEtiquetado value
     * @param string $fechaEtiquetado
     * @return \StructType\DATOSETIQUETAXMLTYPE
     */
    public function setFechaEtiquetado($fechaEtiquetado = null)
    {
        // validation for constraint: string
        if (!is_null($fechaEtiquetado) && !is_string($fechaEtiquetado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaEtiquetado, true), gettype($fechaEtiquetado)), __LINE__);
        }
        $this->FechaEtiquetado = $fechaEtiquetado;
        return $this;
    }
    /**
     * Get CodigoBarras value
     * @return \StructType\FICHEROADJUNTOTYPE|null
     */
    public function getCodigoBarras()
    {
        return $this->CodigoBarras;
    }
    /**
     * Set CodigoBarras value
     * @param \StructType\FICHEROADJUNTOTYPE $codigoBarras
     * @return \StructType\DATOSETIQUETAXMLTYPE
     */
    public function setCodigoBarras(\StructType\FICHEROADJUNTOTYPE $codigoBarras = null)
    {
        $this->CodigoBarras = $codigoBarras;
        return $this;
    }
    /**
     * Get InstruccionesDevolucion value
     * @return string|null
     */
    public function getInstruccionesDevolucion()
    {
        return $this->InstruccionesDevolucion;
    }
    /**
     * Set InstruccionesDevolucion value
     * @uses \EnumType\InstruccionesDevolucion::valueIsValid()
     * @uses \EnumType\InstruccionesDevolucion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $instruccionesDevolucion
     * @return \StructType\DATOSETIQUETAXMLTYPE
     */
    public function setInstruccionesDevolucion($instruccionesDevolucion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InstruccionesDevolucion::valueIsValid($instruccionesDevolucion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InstruccionesDevolucion', is_array($instruccionesDevolucion) ? implode(', ', $instruccionesDevolucion) : var_export($instruccionesDevolucion, true), implode(', ', \EnumType\InstruccionesDevolucion::getValidValues())), __LINE__);
        }
        $this->InstruccionesDevolucion = $instruccionesDevolucion;
        return $this;
    }
    /**
     * Get VA value
     * @return \StructType\VAETIQUETATYPE|null
     */
    public function getVA()
    {
        return $this->VA;
    }
    /**
     * Set VA value
     * @param \StructType\VAETIQUETATYPE $vA
     * @return \StructType\DATOSETIQUETAXMLTYPE
     */
    public function setVA(\StructType\VAETIQUETATYPE $vA = null)
    {
        $this->VA = $vA;
        return $this;
    }
}
