<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Solicitud ServiceType
 * @subpackage Services
 */
class Solicitud extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SolicitudEtiquetaRefCliOp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SolicitudEtiquetaRefCli $solicitudEtiquetaRefCliRequest
     * @return \StructType\RespuestaSolicitudEtiquetaRefCli|bool
     */
    public function SolicitudEtiquetaRefCliOp(\StructType\SolicitudEtiquetaRefCli $solicitudEtiquetaRefCliRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->SolicitudEtiquetaRefCliOp($solicitudEtiquetaRefCliRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SolicitudEtiquetaExpOp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SolicitudEtiquetaExp $solicitudEtiquetaExpRequest
     * @return \StructType\RespuestaSolicitudEtiquetaExp|bool
     */
    public function SolicitudEtiquetaExpOp(\StructType\SolicitudEtiquetaExp $solicitudEtiquetaExpRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->SolicitudEtiquetaExpOp($solicitudEtiquetaExpRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SolicitudEtiquetaOp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SolicitudEtiqueta $solicitudEtiquetaRequest
     * @return \StructType\RespuestaSolicitudEtiqueta|bool
     */
    public function SolicitudEtiquetaOp(\StructType\SolicitudEtiqueta $solicitudEtiquetaRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->SolicitudEtiquetaOp($solicitudEtiquetaRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RespuestaSolicitudEtiqueta|\StructType\RespuestaSolicitudEtiquetaExp|\StructType\RespuestaSolicitudEtiquetaRefCli
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
