<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personelEkle StructType
 * Meta information extracted from the WSDL
 * - type: tns:personelEkle
 * @subpackage Structs
 */
class PersonelEkle extends AbstractStructBase
{
    /**
     * The wsuser
     * @var \StructType\UetdsYtsUser
     */
    public $wsuser;
    /**
     * The uetdsSeferReferansNo
     * @var int
     */
    public $uetdsSeferReferansNo;
    /**
     * The seferPersonelBilgileriInput
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\UetdsAriziSeferPersonelBilgileriInput[]
     */
    public $seferPersonelBilgileriInput;
    /**
     * Constructor method for personelEkle
     * @uses PersonelEkle::setWsuser()
     * @uses PersonelEkle::setUetdsSeferReferansNo()
     * @uses PersonelEkle::setSeferPersonelBilgileriInput()
     * @param \StructType\UetdsYtsUser $wsuser
     * @param int $uetdsSeferReferansNo
     * @param \StructType\UetdsAriziSeferPersonelBilgileriInput[] $seferPersonelBilgileriInput
     */
    public function __construct(\StructType\UetdsYtsUser $wsuser = null, $uetdsSeferReferansNo = null, array $seferPersonelBilgileriInput = array())
    {
        $this
            ->setWsuser($wsuser)
            ->setUetdsSeferReferansNo($uetdsSeferReferansNo)
            ->setSeferPersonelBilgileriInput($seferPersonelBilgileriInput);
    }
    /**
     * Get wsuser value
     * @return \StructType\UetdsYtsUser|null
     */
    public function getWsuser()
    {
        return $this->wsuser;
    }
    /**
     * Set wsuser value
     * @param \StructType\UetdsYtsUser $wsuser
     * @return \StructType\PersonelEkle
     */
    public function setWsuser(\StructType\UetdsYtsUser $wsuser = null)
    {
        $this->wsuser = $wsuser;
        return $this;
    }
    /**
     * Get uetdsSeferReferansNo value
     * @return int|null
     */
    public function getUetdsSeferReferansNo()
    {
        return $this->uetdsSeferReferansNo;
    }
    /**
     * Set uetdsSeferReferansNo value
     * @param int $uetdsSeferReferansNo
     * @return \StructType\PersonelEkle
     */
    public function setUetdsSeferReferansNo($uetdsSeferReferansNo = null)
    {
        // validation for constraint: int
        if (!is_null($uetdsSeferReferansNo) && !(is_int($uetdsSeferReferansNo) || ctype_digit($uetdsSeferReferansNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uetdsSeferReferansNo, true), gettype($uetdsSeferReferansNo)), __LINE__);
        }
        $this->uetdsSeferReferansNo = $uetdsSeferReferansNo;
        return $this;
    }
    /**
     * Get seferPersonelBilgileriInput value
     * @return \StructType\UetdsAriziSeferPersonelBilgileriInput[]|null
     */
    public function getSeferPersonelBilgileriInput()
    {
        return $this->seferPersonelBilgileriInput;
    }
    /**
     * This method is responsible for validating the values passed to the setSeferPersonelBilgileriInput method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeferPersonelBilgileriInput method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeferPersonelBilgileriInputForArrayConstraintsFromSetSeferPersonelBilgileriInput(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personelEkleSeferPersonelBilgileriInputItem) {
            // validation for constraint: itemType
            if (!$personelEkleSeferPersonelBilgileriInputItem instanceof \StructType\UetdsAriziSeferPersonelBilgileriInput) {
                $invalidValues[] = is_object($personelEkleSeferPersonelBilgileriInputItem) ? get_class($personelEkleSeferPersonelBilgileriInputItem) : sprintf('%s(%s)', gettype($personelEkleSeferPersonelBilgileriInputItem), var_export($personelEkleSeferPersonelBilgileriInputItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The seferPersonelBilgileriInput property can only contain items of type \StructType\UetdsAriziSeferPersonelBilgileriInput, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set seferPersonelBilgileriInput value
     * @throws \InvalidArgumentException
     * @param \StructType\UetdsAriziSeferPersonelBilgileriInput[] $seferPersonelBilgileriInput
     * @return \StructType\PersonelEkle
     */
    public function setSeferPersonelBilgileriInput(array $seferPersonelBilgileriInput = array())
    {
        // validation for constraint: array
        if ('' !== ($seferPersonelBilgileriInputArrayErrorMessage = self::validateSeferPersonelBilgileriInputForArrayConstraintsFromSetSeferPersonelBilgileriInput($seferPersonelBilgileriInput))) {
            throw new \InvalidArgumentException($seferPersonelBilgileriInputArrayErrorMessage, __LINE__);
        }
        $this->seferPersonelBilgileriInput = $seferPersonelBilgileriInput;
        return $this;
    }
    /**
     * Add item to seferPersonelBilgileriInput value
     * @throws \InvalidArgumentException
     * @param \StructType\UetdsAriziSeferPersonelBilgileriInput $item
     * @return \StructType\PersonelEkle
     */
    public function addToSeferPersonelBilgileriInput(\StructType\UetdsAriziSeferPersonelBilgileriInput $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UetdsAriziSeferPersonelBilgileriInput) {
            throw new \InvalidArgumentException(sprintf('The seferPersonelBilgileriInput property can only contain items of type \StructType\UetdsAriziSeferPersonelBilgileriInput, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->seferPersonelBilgileriInput[] = $item;
        return $this;
    }
}
