<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Servis ServiceType
 * @subpackage Services
 */
class Servis extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named servisTest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $testMsj1
     * @return string|bool
     */
    public function servisTest($testMsj1)
    {
        try {
            $this->setResult($this->getSoapClient()->servisTest($testMsj1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
