<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Personel ServiceType
 * @subpackage Services
 */
class Personel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named personelEkle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PersonelEkle $parameters
     * @return \StructType\PersonelEkleResponse|bool
     */
    public function personelEkle(\StructType\PersonelEkle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->personelEkle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named personelIptal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PersonelIptal $parameters
     * @return \StructType\PersonelIptalResponse|bool
     */
    public function personelIptal(\StructType\PersonelIptal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->personelIptal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PersonelEkleResponse|\StructType\PersonelIptalResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
