<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kimlik ServiceType
 * @subpackage Services
 */
class Kimlik extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named kimlikDogrulama
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KimlikDogrulama $parameters
     * @return \StructType\KimlikDogrulamaResponse|bool
     */
    public function kimlikDogrulama(\StructType\KimlikDogrulama $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->kimlikDogrulama($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KimlikDogrulamaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
