<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Hes ServiceType
 * @subpackage Services
 */
class Hes extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named hesKoduBlokeKaldir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HesKoduBlokeKaldir $parameters
     * @return \StructType\HesKoduBlokeKaldirResponse|bool
     */
    public function hesKoduBlokeKaldir(\StructType\HesKoduBlokeKaldir $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->hesKoduBlokeKaldir($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hesKoduKontrolEt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HesKoduKontrolEt $parameters
     * @return \StructType\HesKoduKontrolEtResponse|bool
     */
    public function hesKoduKontrolEt(\StructType\HesKoduKontrolEt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->hesKoduKontrolEt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hesKoduKontrolEtPlus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HesKoduKontrolEtPlus $parameters
     * @return \StructType\HesKoduKontrolEtPlusResponse|bool
     */
    public function hesKoduKontrolEtPlus(\StructType\HesKoduKontrolEtPlus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->hesKoduKontrolEtPlus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hesKoduBlokeEt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HesKoduBlokeEt $parameters
     * @return \StructType\HesKoduBlokeEtResponse|bool
     */
    public function hesKoduBlokeEt(\StructType\HesKoduBlokeEt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->hesKoduBlokeEt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\HesKoduBlokeEtResponse|\StructType\HesKoduBlokeKaldirResponse|\StructType\HesKoduKontrolEtPlusResponse|\StructType\HesKoduKontrolEtResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
