<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for uetdsSeyahatIzinKontrolSonuc StructType
 * @subpackage Structs
 */
class UetdsSeyahatIzinKontrolSonuc extends AbstractStructBase
{
    /**
     * The sonucKodu
     * @var int
     */
    public $sonucKodu;
    /**
     * The sonucMesaji
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sonucMesaji;
    /**
     * The kayitlar
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SeyahatIzinKontrolApiDataResponse[]
     */
    public $kayitlar;
    /**
     * Constructor method for uetdsSeyahatIzinKontrolSonuc
     * @uses UetdsSeyahatIzinKontrolSonuc::setSonucKodu()
     * @uses UetdsSeyahatIzinKontrolSonuc::setSonucMesaji()
     * @uses UetdsSeyahatIzinKontrolSonuc::setKayitlar()
     * @param int $sonucKodu
     * @param string $sonucMesaji
     * @param \StructType\SeyahatIzinKontrolApiDataResponse[] $kayitlar
     */
    public function __construct($sonucKodu = null, $sonucMesaji = null, array $kayitlar = array())
    {
        $this
            ->setSonucKodu($sonucKodu)
            ->setSonucMesaji($sonucMesaji)
            ->setKayitlar($kayitlar);
    }
    /**
     * Get sonucKodu value
     * @return int|null
     */
    public function getSonucKodu()
    {
        return $this->sonucKodu;
    }
    /**
     * Set sonucKodu value
     * @param int $sonucKodu
     * @return \StructType\UetdsSeyahatIzinKontrolSonuc
     */
    public function setSonucKodu($sonucKodu = null)
    {
        // validation for constraint: int
        if (!is_null($sonucKodu) && !(is_int($sonucKodu) || ctype_digit($sonucKodu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sonucKodu, true), gettype($sonucKodu)), __LINE__);
        }
        $this->sonucKodu = $sonucKodu;
        return $this;
    }
    /**
     * Get sonucMesaji value
     * @return string|null
     */
    public function getSonucMesaji()
    {
        return $this->sonucMesaji;
    }
    /**
     * Set sonucMesaji value
     * @param string $sonucMesaji
     * @return \StructType\UetdsSeyahatIzinKontrolSonuc
     */
    public function setSonucMesaji($sonucMesaji = null)
    {
        // validation for constraint: string
        if (!is_null($sonucMesaji) && !is_string($sonucMesaji)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonucMesaji, true), gettype($sonucMesaji)), __LINE__);
        }
        $this->sonucMesaji = $sonucMesaji;
        return $this;
    }
    /**
     * Get kayitlar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SeyahatIzinKontrolApiDataResponse[]|null
     */
    public function getKayitlar()
    {
        return isset($this->kayitlar) ? $this->kayitlar : null;
    }
    /**
     * This method is responsible for validating the values passed to the setKayitlar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKayitlar method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKayitlarForArrayConstraintsFromSetKayitlar(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uetdsSeyahatIzinKontrolSonucKayitlarItem) {
            // validation for constraint: itemType
            if (!$uetdsSeyahatIzinKontrolSonucKayitlarItem instanceof \StructType\SeyahatIzinKontrolApiDataResponse) {
                $invalidValues[] = is_object($uetdsSeyahatIzinKontrolSonucKayitlarItem) ? get_class($uetdsSeyahatIzinKontrolSonucKayitlarItem) : sprintf('%s(%s)', gettype($uetdsSeyahatIzinKontrolSonucKayitlarItem), var_export($uetdsSeyahatIzinKontrolSonucKayitlarItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kayitlar property can only contain items of type \StructType\SeyahatIzinKontrolApiDataResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kayitlar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SeyahatIzinKontrolApiDataResponse[] $kayitlar
     * @return \StructType\UetdsSeyahatIzinKontrolSonuc
     */
    public function setKayitlar(array $kayitlar = array())
    {
        // validation for constraint: array
        if ('' !== ($kayitlarArrayErrorMessage = self::validateKayitlarForArrayConstraintsFromSetKayitlar($kayitlar))) {
            throw new \InvalidArgumentException($kayitlarArrayErrorMessage, __LINE__);
        }
        if (is_null($kayitlar) || (is_array($kayitlar) && empty($kayitlar))) {
            unset($this->kayitlar);
        } else {
            $this->kayitlar = $kayitlar;
        }
        return $this;
    }
    /**
     * Add item to kayitlar value
     * @throws \InvalidArgumentException
     * @param \StructType\SeyahatIzinKontrolApiDataResponse $item
     * @return \StructType\UetdsSeyahatIzinKontrolSonuc
     */
    public function addToKayitlar(\StructType\SeyahatIzinKontrolApiDataResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeyahatIzinKontrolApiDataResponse) {
            throw new \InvalidArgumentException(sprintf('The kayitlar property can only contain items of type \StructType\SeyahatIzinKontrolApiDataResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kayitlar[] = $item;
        return $this;
    }
}
