<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mesleki ServiceType
 * @subpackage Services
 */
class Mesleki extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named meslekiYeterlilikSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MeslekiYeterlilikSorgula $parameters
     * @return \StructType\MeslekiYeterlilikSorgulaResponse|bool
     */
    public function meslekiYeterlilikSorgula(\StructType\MeslekiYeterlilikSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->meslekiYeterlilikSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MeslekiYeterlilikSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
