<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kullanici ServiceType
 * @subpackage Services
 */
class Kullanici extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named kullaniciKontrol
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KullaniciKontrol $parameters
     * @return \StructType\KullaniciKontrolResponse|bool
     */
    public function kullaniciKontrol(\StructType\KullaniciKontrol $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->kullaniciKontrol($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KullaniciKontrolResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
