<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bildirim ServiceType
 * @subpackage Services
 */
class Bildirim extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named bildirimOzeti
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BildirimOzeti $parameters
     * @return \StructType\BildirimOzetiResponse|bool
     */
    public function bildirimOzeti(\StructType\BildirimOzeti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->bildirimOzeti($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BildirimOzetiResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
