<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ats ServiceType
 * @subpackage Services
 */
class Ats extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named atsArizaBildir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtsArizaBildir $parameters
     * @return \StructType\AtsArizaBildirResponse|bool
     */
    public function atsArizaBildir(\StructType\AtsArizaBildir $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->atsArizaBildir($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named atsKonumBildir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtsKonumBildir $parameters
     * @return \StructType\AtsKonumBildirResponse|bool
     */
    public function atsKonumBildir(\StructType\AtsKonumBildir $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->atsKonumBildir($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AtsArizaBildirResponse|\StructType\AtsKonumBildirResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
