<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ip ServiceType
 * @subpackage Services
 */
class Ip extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ipListele
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IpListele $parameters
     * @return \StructType\IpListeleResponse|bool
     */
    public function ipListele(\StructType\IpListele $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ipListele($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ipSil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IpSil $parameters
     * @return \StructType\IpSilResponse|bool
     */
    public function ipSil(\StructType\IpSil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ipSil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ipTanimla
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IpTanimla $parameters
     * @return \StructType\IpTanimlaResponse|bool
     */
    public function ipTanimla(\StructType\IpTanimla $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ipTanimla($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IpListeleResponse|\StructType\IpSilResponse|\StructType\IpTanimlaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
