<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Firma ServiceType
 * @subpackage Services
 */
class Firma extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named firmaCezaSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FirmaCezaSorgula $parameters
     * @return \StructType\FirmaCezaSorgulaResponse|bool
     */
    public function firmaCezaSorgula(\StructType\FirmaCezaSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->firmaCezaSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named firmaIletisimBilgisiListele
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FirmaIletisimBilgisiListele $parameters
     * @return \StructType\FirmaIletisimBilgisiListeleResponse|bool
     */
    public function firmaIletisimBilgisiListele(\StructType\FirmaIletisimBilgisiListele $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->firmaIletisimBilgisiListele($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named firmaIletisimBilgisiSil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FirmaIletisimBilgisiSil $parameters
     * @return \StructType\FirmaIletisimBilgisiSilResponse|bool
     */
    public function firmaIletisimBilgisiSil(\StructType\FirmaIletisimBilgisiSil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->firmaIletisimBilgisiSil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named firmaIletisimBilgisiEkle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FirmaIletisimBilgisiEkle $parameters
     * @return \StructType\FirmaIletisimBilgisiEkleResponse|bool
     */
    public function firmaIletisimBilgisiEkle(\StructType\FirmaIletisimBilgisiEkle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->firmaIletisimBilgisiEkle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named firmaUyarmaSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FirmaUyarmaSorgula $parameters
     * @return \StructType\FirmaUyarmaSorgulaResponse|bool
     */
    public function firmaUyarmaSorgula(\StructType\FirmaUyarmaSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->firmaUyarmaSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FirmaCezaSorgulaResponse|\StructType\FirmaIletisimBilgisiEkleResponse|\StructType\FirmaIletisimBilgisiListeleResponse|\StructType\FirmaIletisimBilgisiSilResponse|\StructType\FirmaUyarmaSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
