<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Arac ServiceType
 * @subpackage Services
 */
class Arac extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named aracMuayeneSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AracMuayeneSorgula $parameters
     * @return \StructType\AracMuayeneSorgulaResponse|bool
     */
    public function aracMuayeneSorgula(\StructType\AracMuayeneSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->aracMuayeneSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AracMuayeneSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
