<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for uetdsAriziYolcuIslemSonuc StructType
 * @subpackage Structs
 */
class UetdsAriziYolcuIslemSonuc extends AbstractStructBase
{
    /**
     * The sonucKodu
     * @var int
     */
    public $sonucKodu;
    /**
     * The sonucMesaji
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sonucMesaji;
    /**
     * The uetdsYolcuRefNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $uetdsYolcuRefNo;
    /**
     * The seferBilgisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UetdsAriziSeferBilgileri
     */
    public $seferBilgisi;
    /**
     * The yolcuList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UetdsAriziSeferYolcuListesi[]
     */
    public $yolcuList;
    /**
     * The yolcuDetay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UetdsAriziSeferYolcuByYolcuRefNo
     */
    public $yolcuDetay;
    /**
     * The grupDetay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CstUetdsAriziGrupDetay
     */
    public $grupDetay;
    /**
     * Constructor method for uetdsAriziYolcuIslemSonuc
     * @uses UetdsAriziYolcuIslemSonuc::setSonucKodu()
     * @uses UetdsAriziYolcuIslemSonuc::setSonucMesaji()
     * @uses UetdsAriziYolcuIslemSonuc::setUetdsYolcuRefNo()
     * @uses UetdsAriziYolcuIslemSonuc::setSeferBilgisi()
     * @uses UetdsAriziYolcuIslemSonuc::setYolcuList()
     * @uses UetdsAriziYolcuIslemSonuc::setYolcuDetay()
     * @uses UetdsAriziYolcuIslemSonuc::setGrupDetay()
     * @param int $sonucKodu
     * @param string $sonucMesaji
     * @param string $uetdsYolcuRefNo
     * @param \StructType\UetdsAriziSeferBilgileri $seferBilgisi
     * @param \StructType\UetdsAriziSeferYolcuListesi[] $yolcuList
     * @param \StructType\UetdsAriziSeferYolcuByYolcuRefNo $yolcuDetay
     * @param \StructType\CstUetdsAriziGrupDetay $grupDetay
     */
    public function __construct($sonucKodu = null, $sonucMesaji = null, $uetdsYolcuRefNo = null, \StructType\UetdsAriziSeferBilgileri $seferBilgisi = null, array $yolcuList = array(), \StructType\UetdsAriziSeferYolcuByYolcuRefNo $yolcuDetay = null, \StructType\CstUetdsAriziGrupDetay $grupDetay = null)
    {
        $this
            ->setSonucKodu($sonucKodu)
            ->setSonucMesaji($sonucMesaji)
            ->setUetdsYolcuRefNo($uetdsYolcuRefNo)
            ->setSeferBilgisi($seferBilgisi)
            ->setYolcuList($yolcuList)
            ->setYolcuDetay($yolcuDetay)
            ->setGrupDetay($grupDetay);
    }
    /**
     * Get sonucKodu value
     * @return int|null
     */
    public function getSonucKodu()
    {
        return $this->sonucKodu;
    }
    /**
     * Set sonucKodu value
     * @param int $sonucKodu
     * @return \StructType\UetdsAriziYolcuIslemSonuc
     */
    public function setSonucKodu($sonucKodu = null)
    {
        // validation for constraint: int
        if (!is_null($sonucKodu) && !(is_int($sonucKodu) || ctype_digit($sonucKodu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sonucKodu, true), gettype($sonucKodu)), __LINE__);
        }
        $this->sonucKodu = $sonucKodu;
        return $this;
    }
    /**
     * Get sonucMesaji value
     * @return string|null
     */
    public function getSonucMesaji()
    {
        return $this->sonucMesaji;
    }
    /**
     * Set sonucMesaji value
     * @param string $sonucMesaji
     * @return \StructType\UetdsAriziYolcuIslemSonuc
     */
    public function setSonucMesaji($sonucMesaji = null)
    {
        // validation for constraint: string
        if (!is_null($sonucMesaji) && !is_string($sonucMesaji)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonucMesaji, true), gettype($sonucMesaji)), __LINE__);
        }
        $this->sonucMesaji = $sonucMesaji;
        return $this;
    }
    /**
     * Get uetdsYolcuRefNo value
     * @return string|null
     */
    public function getUetdsYolcuRefNo()
    {
        return $this->uetdsYolcuRefNo;
    }
    /**
     * Set uetdsYolcuRefNo value
     * @param string $uetdsYolcuRefNo
     * @return \StructType\UetdsAriziYolcuIslemSonuc
     */
    public function setUetdsYolcuRefNo($uetdsYolcuRefNo = null)
    {
        // validation for constraint: string
        if (!is_null($uetdsYolcuRefNo) && !is_string($uetdsYolcuRefNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uetdsYolcuRefNo, true), gettype($uetdsYolcuRefNo)), __LINE__);
        }
        $this->uetdsYolcuRefNo = $uetdsYolcuRefNo;
        return $this;
    }
    /**
     * Get seferBilgisi value
     * @return \StructType\UetdsAriziSeferBilgileri|null
     */
    public function getSeferBilgisi()
    {
        return $this->seferBilgisi;
    }
    /**
     * Set seferBilgisi value
     * @param \StructType\UetdsAriziSeferBilgileri $seferBilgisi
     * @return \StructType\UetdsAriziYolcuIslemSonuc
     */
    public function setSeferBilgisi(\StructType\UetdsAriziSeferBilgileri $seferBilgisi = null)
    {
        $this->seferBilgisi = $seferBilgisi;
        return $this;
    }
    /**
     * Get yolcuList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UetdsAriziSeferYolcuListesi[]|null
     */
    public function getYolcuList()
    {
        return isset($this->yolcuList) ? $this->yolcuList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setYolcuList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setYolcuList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateYolcuListForArrayConstraintsFromSetYolcuList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uetdsAriziYolcuIslemSonucYolcuListItem) {
            // validation for constraint: itemType
            if (!$uetdsAriziYolcuIslemSonucYolcuListItem instanceof \StructType\UetdsAriziSeferYolcuListesi) {
                $invalidValues[] = is_object($uetdsAriziYolcuIslemSonucYolcuListItem) ? get_class($uetdsAriziYolcuIslemSonucYolcuListItem) : sprintf('%s(%s)', gettype($uetdsAriziYolcuIslemSonucYolcuListItem), var_export($uetdsAriziYolcuIslemSonucYolcuListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The yolcuList property can only contain items of type \StructType\UetdsAriziSeferYolcuListesi, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set yolcuList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UetdsAriziSeferYolcuListesi[] $yolcuList
     * @return \StructType\UetdsAriziYolcuIslemSonuc
     */
    public function setYolcuList(array $yolcuList = array())
    {
        // validation for constraint: array
        if ('' !== ($yolcuListArrayErrorMessage = self::validateYolcuListForArrayConstraintsFromSetYolcuList($yolcuList))) {
            throw new \InvalidArgumentException($yolcuListArrayErrorMessage, __LINE__);
        }
        if (is_null($yolcuList) || (is_array($yolcuList) && empty($yolcuList))) {
            unset($this->yolcuList);
        } else {
            $this->yolcuList = $yolcuList;
        }
        return $this;
    }
    /**
     * Add item to yolcuList value
     * @throws \InvalidArgumentException
     * @param \StructType\UetdsAriziSeferYolcuListesi $item
     * @return \StructType\UetdsAriziYolcuIslemSonuc
     */
    public function addToYolcuList(\StructType\UetdsAriziSeferYolcuListesi $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UetdsAriziSeferYolcuListesi) {
            throw new \InvalidArgumentException(sprintf('The yolcuList property can only contain items of type \StructType\UetdsAriziSeferYolcuListesi, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->yolcuList[] = $item;
        return $this;
    }
    /**
     * Get yolcuDetay value
     * @return \StructType\UetdsAriziSeferYolcuByYolcuRefNo|null
     */
    public function getYolcuDetay()
    {
        return $this->yolcuDetay;
    }
    /**
     * Set yolcuDetay value
     * @param \StructType\UetdsAriziSeferYolcuByYolcuRefNo $yolcuDetay
     * @return \StructType\UetdsAriziYolcuIslemSonuc
     */
    public function setYolcuDetay(\StructType\UetdsAriziSeferYolcuByYolcuRefNo $yolcuDetay = null)
    {
        $this->yolcuDetay = $yolcuDetay;
        return $this;
    }
    /**
     * Get grupDetay value
     * @return \StructType\CstUetdsAriziGrupDetay|null
     */
    public function getGrupDetay()
    {
        return $this->grupDetay;
    }
    /**
     * Set grupDetay value
     * @param \StructType\CstUetdsAriziGrupDetay $grupDetay
     * @return \StructType\UetdsAriziYolcuIslemSonuc
     */
    public function setGrupDetay(\StructType\CstUetdsAriziGrupDetay $grupDetay = null)
    {
        $this->grupDetay = $grupDetay;
        return $this;
    }
}
