<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for uetdsAriziGrupIslemSonuc StructType
 * @subpackage Structs
 */
class UetdsAriziGrupIslemSonuc extends AbstractStructBase
{
    /**
     * The sonucKodu
     * @var int
     */
    public $sonucKodu;
    /**
     * The sonucMesaji
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sonucMesaji;
    /**
     * The uetdsGrupRefNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $uetdsGrupRefNo;
    /**
     * The seferBilgisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UetdsAriziSeferBilgileri
     */
    public $seferBilgisi;
    /**
     * The grupListe
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CstUetdsAriziGrupListe[]
     */
    public $grupListe;
    /**
     * The grupDetay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CstUetdsAriziGrupDetay
     */
    public $grupDetay;
    /**
     * Constructor method for uetdsAriziGrupIslemSonuc
     * @uses UetdsAriziGrupIslemSonuc::setSonucKodu()
     * @uses UetdsAriziGrupIslemSonuc::setSonucMesaji()
     * @uses UetdsAriziGrupIslemSonuc::setUetdsGrupRefNo()
     * @uses UetdsAriziGrupIslemSonuc::setSeferBilgisi()
     * @uses UetdsAriziGrupIslemSonuc::setGrupListe()
     * @uses UetdsAriziGrupIslemSonuc::setGrupDetay()
     * @param int $sonucKodu
     * @param string $sonucMesaji
     * @param string $uetdsGrupRefNo
     * @param \StructType\UetdsAriziSeferBilgileri $seferBilgisi
     * @param \StructType\CstUetdsAriziGrupListe[] $grupListe
     * @param \StructType\CstUetdsAriziGrupDetay $grupDetay
     */
    public function __construct($sonucKodu = null, $sonucMesaji = null, $uetdsGrupRefNo = null, \StructType\UetdsAriziSeferBilgileri $seferBilgisi = null, array $grupListe = array(), \StructType\CstUetdsAriziGrupDetay $grupDetay = null)
    {
        $this
            ->setSonucKodu($sonucKodu)
            ->setSonucMesaji($sonucMesaji)
            ->setUetdsGrupRefNo($uetdsGrupRefNo)
            ->setSeferBilgisi($seferBilgisi)
            ->setGrupListe($grupListe)
            ->setGrupDetay($grupDetay);
    }
    /**
     * Get sonucKodu value
     * @return int|null
     */
    public function getSonucKodu()
    {
        return $this->sonucKodu;
    }
    /**
     * Set sonucKodu value
     * @param int $sonucKodu
     * @return \StructType\UetdsAriziGrupIslemSonuc
     */
    public function setSonucKodu($sonucKodu = null)
    {
        // validation for constraint: int
        if (!is_null($sonucKodu) && !(is_int($sonucKodu) || ctype_digit($sonucKodu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sonucKodu, true), gettype($sonucKodu)), __LINE__);
        }
        $this->sonucKodu = $sonucKodu;
        return $this;
    }
    /**
     * Get sonucMesaji value
     * @return string|null
     */
    public function getSonucMesaji()
    {
        return $this->sonucMesaji;
    }
    /**
     * Set sonucMesaji value
     * @param string $sonucMesaji
     * @return \StructType\UetdsAriziGrupIslemSonuc
     */
    public function setSonucMesaji($sonucMesaji = null)
    {
        // validation for constraint: string
        if (!is_null($sonucMesaji) && !is_string($sonucMesaji)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonucMesaji, true), gettype($sonucMesaji)), __LINE__);
        }
        $this->sonucMesaji = $sonucMesaji;
        return $this;
    }
    /**
     * Get uetdsGrupRefNo value
     * @return string|null
     */
    public function getUetdsGrupRefNo()
    {
        return $this->uetdsGrupRefNo;
    }
    /**
     * Set uetdsGrupRefNo value
     * @param string $uetdsGrupRefNo
     * @return \StructType\UetdsAriziGrupIslemSonuc
     */
    public function setUetdsGrupRefNo($uetdsGrupRefNo = null)
    {
        // validation for constraint: string
        if (!is_null($uetdsGrupRefNo) && !is_string($uetdsGrupRefNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uetdsGrupRefNo, true), gettype($uetdsGrupRefNo)), __LINE__);
        }
        $this->uetdsGrupRefNo = $uetdsGrupRefNo;
        return $this;
    }
    /**
     * Get seferBilgisi value
     * @return \StructType\UetdsAriziSeferBilgileri|null
     */
    public function getSeferBilgisi()
    {
        return $this->seferBilgisi;
    }
    /**
     * Set seferBilgisi value
     * @param \StructType\UetdsAriziSeferBilgileri $seferBilgisi
     * @return \StructType\UetdsAriziGrupIslemSonuc
     */
    public function setSeferBilgisi(\StructType\UetdsAriziSeferBilgileri $seferBilgisi = null)
    {
        $this->seferBilgisi = $seferBilgisi;
        return $this;
    }
    /**
     * Get grupListe value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CstUetdsAriziGrupListe[]|null
     */
    public function getGrupListe()
    {
        return isset($this->grupListe) ? $this->grupListe : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGrupListe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGrupListe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGrupListeForArrayConstraintsFromSetGrupListe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uetdsAriziGrupIslemSonucGrupListeItem) {
            // validation for constraint: itemType
            if (!$uetdsAriziGrupIslemSonucGrupListeItem instanceof \StructType\CstUetdsAriziGrupListe) {
                $invalidValues[] = is_object($uetdsAriziGrupIslemSonucGrupListeItem) ? get_class($uetdsAriziGrupIslemSonucGrupListeItem) : sprintf('%s(%s)', gettype($uetdsAriziGrupIslemSonucGrupListeItem), var_export($uetdsAriziGrupIslemSonucGrupListeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The grupListe property can only contain items of type \StructType\CstUetdsAriziGrupListe, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set grupListe value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CstUetdsAriziGrupListe[] $grupListe
     * @return \StructType\UetdsAriziGrupIslemSonuc
     */
    public function setGrupListe(array $grupListe = array())
    {
        // validation for constraint: array
        if ('' !== ($grupListeArrayErrorMessage = self::validateGrupListeForArrayConstraintsFromSetGrupListe($grupListe))) {
            throw new \InvalidArgumentException($grupListeArrayErrorMessage, __LINE__);
        }
        if (is_null($grupListe) || (is_array($grupListe) && empty($grupListe))) {
            unset($this->grupListe);
        } else {
            $this->grupListe = $grupListe;
        }
        return $this;
    }
    /**
     * Add item to grupListe value
     * @throws \InvalidArgumentException
     * @param \StructType\CstUetdsAriziGrupListe $item
     * @return \StructType\UetdsAriziGrupIslemSonuc
     */
    public function addToGrupListe(\StructType\CstUetdsAriziGrupListe $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CstUetdsAriziGrupListe) {
            throw new \InvalidArgumentException(sprintf('The grupListe property can only contain items of type \StructType\CstUetdsAriziGrupListe, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->grupListe[] = $item;
        return $this;
    }
    /**
     * Get grupDetay value
     * @return \StructType\CstUetdsAriziGrupDetay|null
     */
    public function getGrupDetay()
    {
        return $this->grupDetay;
    }
    /**
     * Set grupDetay value
     * @param \StructType\CstUetdsAriziGrupDetay $grupDetay
     * @return \StructType\UetdsAriziGrupIslemSonuc
     */
    public function setGrupDetay(\StructType\CstUetdsAriziGrupDetay $grupDetay = null)
    {
        $this->grupDetay = $grupDetay;
        return $this;
    }
}
