<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sefer ServiceType
 * @subpackage Services
 */
class Sefer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named seferPlakaDegistir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferPlakaDegistir $parameters
     * @return \StructType\SeferPlakaDegistirResponse|bool
     */
    public function seferPlakaDegistir(\StructType\SeferPlakaDegistir $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferPlakaDegistir($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferGrupIptal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferGrupIptal $parameters
     * @return \StructType\SeferGrupIptalResponse|bool
     */
    public function seferGrupIptal(\StructType\SeferGrupIptal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferGrupIptal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferGuncelle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferGuncelle $parameters
     * @return \StructType\SeferGuncelleResponse|bool
     */
    public function seferGuncelle(\StructType\SeferGuncelle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferGuncelle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferGrupGuncelle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferGrupGuncelle $parameters
     * @return \StructType\SeferGrupGuncelleResponse|bool
     */
    public function seferGrupGuncelle(\StructType\SeferGrupGuncelle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferGrupGuncelle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferEkle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferEkle $parameters
     * @return \StructType\SeferEkleResponse|bool
     */
    public function seferEkle(\StructType\SeferEkle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferEkle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferGrupEkle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferGrupEkle $parameters
     * @return \StructType\SeferGrupEkleResponse|bool
     */
    public function seferGrupEkle(\StructType\SeferGrupEkle $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferGrupEkle($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferIptal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferIptal $parameters
     * @return \StructType\SeferIptalResponse|bool
     */
    public function seferIptal(\StructType\SeferIptal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferIptal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferDetayCiktisiAl
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferDetayCiktisiAl $parameters
     * @return \StructType\SeferDetayCiktisiAlResponse|bool
     */
    public function seferDetayCiktisiAl(\StructType\SeferDetayCiktisiAl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferDetayCiktisiAl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferBildirimListele
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferBildirimListele $parameters
     * @return \StructType\SeferBildirimListeleResponse|bool
     */
    public function seferBildirimListele(\StructType\SeferBildirimListele $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferBildirimListele($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferGrupListesi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferGrupListesi $parameters
     * @return \StructType\SeferGrupListesiResponse|bool
     */
    public function seferGrupListesi(\StructType\SeferGrupListesi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferGrupListesi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named seferAktif
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeferAktif $parameters
     * @return \StructType\SeferAktifResponse|bool
     */
    public function seferAktif(\StructType\SeferAktif $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->seferAktif($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SeferAktifResponse|\StructType\SeferBildirimListeleResponse|\StructType\SeferDetayCiktisiAlResponse|\StructType\SeferEkleResponse|\StructType\SeferGrupEkleResponse|\StructType\SeferGrupGuncelleResponse|\StructType\SeferGrupIptalResponse|\StructType\SeferGrupListesiResponse|\StructType\SeferGuncelleResponse|\StructType\SeferIptalResponse|\StructType\SeferPlakaDegistirResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
