<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetTemplateVariableValue StructType
 * @subpackage Structs
 */
class SetTemplateVariableValue extends AbstractStructBase
{
    /**
     * The MailingGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $MailingGUID;
    /**
     * The TemplateGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $TemplateGUID;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The VariableName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VariableName;
    /**
     * The VariableValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VariableValue;
    /**
     * The ReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFormat;
    /**
     * Constructor method for SetTemplateVariableValue
     * @uses SetTemplateVariableValue::setMailingGUID()
     * @uses SetTemplateVariableValue::setTemplateGUID()
     * @uses SetTemplateVariableValue::setUsername()
     * @uses SetTemplateVariableValue::setPassword()
     * @uses SetTemplateVariableValue::setVariableName()
     * @uses SetTemplateVariableValue::setVariableValue()
     * @uses SetTemplateVariableValue::setReturnFormat()
     * @param string $mailingGUID
     * @param string $templateGUID
     * @param string $username
     * @param string $password
     * @param string $variableName
     * @param string $variableValue
     * @param string $returnFormat
     */
    public function __construct($mailingGUID = null, $templateGUID = null, $username = null, $password = null, $variableName = null, $variableValue = null, $returnFormat = null)
    {
        $this
            ->setMailingGUID($mailingGUID)
            ->setTemplateGUID($templateGUID)
            ->setUsername($username)
            ->setPassword($password)
            ->setVariableName($variableName)
            ->setVariableValue($variableValue)
            ->setReturnFormat($returnFormat);
    }
    /**
     * Get MailingGUID value
     * @return string
     */
    public function getMailingGUID()
    {
        return $this->MailingGUID;
    }
    /**
     * Set MailingGUID value
     * @param string $mailingGUID
     * @return \StructType\SetTemplateVariableValue
     */
    public function setMailingGUID($mailingGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mailingGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($mailingGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mailingGUID) && !is_string($mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingGUID)), __LINE__);
        }
        $this->MailingGUID = $mailingGUID;
        return $this;
    }
    /**
     * Get TemplateGUID value
     * @return string
     */
    public function getTemplateGUID()
    {
        return $this->TemplateGUID;
    }
    /**
     * Set TemplateGUID value
     * @param string $templateGUID
     * @return \StructType\SetTemplateVariableValue
     */
    public function setTemplateGUID($templateGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($templateGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $templateGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($templateGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($templateGUID) && !is_string($templateGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($templateGUID)), __LINE__);
        }
        $this->TemplateGUID = $templateGUID;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\SetTemplateVariableValue
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\SetTemplateVariableValue
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get VariableName value
     * @return string|null
     */
    public function getVariableName()
    {
        return $this->VariableName;
    }
    /**
     * Set VariableName value
     * @param string $variableName
     * @return \StructType\SetTemplateVariableValue
     */
    public function setVariableName($variableName = null)
    {
        // validation for constraint: string
        if (!is_null($variableName) && !is_string($variableName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($variableName)), __LINE__);
        }
        $this->VariableName = $variableName;
        return $this;
    }
    /**
     * Get VariableValue value
     * @return string|null
     */
    public function getVariableValue()
    {
        return $this->VariableValue;
    }
    /**
     * Set VariableValue value
     * @param string $variableValue
     * @return \StructType\SetTemplateVariableValue
     */
    public function setVariableValue($variableValue = null)
    {
        // validation for constraint: string
        if (!is_null($variableValue) && !is_string($variableValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($variableValue)), __LINE__);
        }
        $this->VariableValue = $variableValue;
        return $this;
    }
    /**
     * Get ReturnFormat value
     * @return string|null
     */
    public function getReturnFormat()
    {
        return $this->ReturnFormat;
    }
    /**
     * Set ReturnFormat value
     * @param string $returnFormat
     * @return \StructType\SetTemplateVariableValue
     */
    public function setReturnFormat($returnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($returnFormat) && !is_string($returnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFormat)), __LINE__);
        }
        $this->ReturnFormat = $returnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetTemplateVariableValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
