<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessMailing StructType
 * @subpackage Structs
 */
class ProcessMailing extends AbstractStructBase
{
    /**
     * The MailingGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $MailingGUID;
    /**
     * The Submit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Submit;
    /**
     * The PartialProcess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PartialProcess;
    /**
     * The MaxPriceExVAT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MaxPriceExVAT;
    /**
     * The SkipPreviewImageGeneration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SkipPreviewImageGeneration;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The CustomerApplication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerApplication;
    /**
     * The POReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $POReference;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentMethod;
    /**
     * The EmailSuccessList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailSuccessList;
    /**
     * The EmailErrorList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailErrorList;
    /**
     * The HttpPostOnSuccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HttpPostOnSuccess;
    /**
     * The HttpPostOnError
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HttpPostOnError;
    /**
     * The ReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFormat;
    /**
     * Constructor method for ProcessMailing
     * @uses ProcessMailing::setMailingGUID()
     * @uses ProcessMailing::setSubmit()
     * @uses ProcessMailing::setPartialProcess()
     * @uses ProcessMailing::setMaxPriceExVAT()
     * @uses ProcessMailing::setSkipPreviewImageGeneration()
     * @uses ProcessMailing::setUsername()
     * @uses ProcessMailing::setPassword()
     * @uses ProcessMailing::setCustomerApplication()
     * @uses ProcessMailing::setPOReference()
     * @uses ProcessMailing::setPaymentMethod()
     * @uses ProcessMailing::setEmailSuccessList()
     * @uses ProcessMailing::setEmailErrorList()
     * @uses ProcessMailing::setHttpPostOnSuccess()
     * @uses ProcessMailing::setHttpPostOnError()
     * @uses ProcessMailing::setReturnFormat()
     * @param string $mailingGUID
     * @param bool $submit
     * @param bool $partialProcess
     * @param float $maxPriceExVAT
     * @param bool $skipPreviewImageGeneration
     * @param string $username
     * @param string $password
     * @param string $customerApplication
     * @param string $pOReference
     * @param string $paymentMethod
     * @param string $emailSuccessList
     * @param string $emailErrorList
     * @param string $httpPostOnSuccess
     * @param string $httpPostOnError
     * @param string $returnFormat
     */
    public function __construct($mailingGUID = null, $submit = null, $partialProcess = null, $maxPriceExVAT = null, $skipPreviewImageGeneration = null, $username = null, $password = null, $customerApplication = null, $pOReference = null, $paymentMethod = null, $emailSuccessList = null, $emailErrorList = null, $httpPostOnSuccess = null, $httpPostOnError = null, $returnFormat = null)
    {
        $this
            ->setMailingGUID($mailingGUID)
            ->setSubmit($submit)
            ->setPartialProcess($partialProcess)
            ->setMaxPriceExVAT($maxPriceExVAT)
            ->setSkipPreviewImageGeneration($skipPreviewImageGeneration)
            ->setUsername($username)
            ->setPassword($password)
            ->setCustomerApplication($customerApplication)
            ->setPOReference($pOReference)
            ->setPaymentMethod($paymentMethod)
            ->setEmailSuccessList($emailSuccessList)
            ->setEmailErrorList($emailErrorList)
            ->setHttpPostOnSuccess($httpPostOnSuccess)
            ->setHttpPostOnError($httpPostOnError)
            ->setReturnFormat($returnFormat);
    }
    /**
     * Get MailingGUID value
     * @return string
     */
    public function getMailingGUID()
    {
        return $this->MailingGUID;
    }
    /**
     * Set MailingGUID value
     * @param string $mailingGUID
     * @return \StructType\ProcessMailing
     */
    public function setMailingGUID($mailingGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mailingGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($mailingGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mailingGUID) && !is_string($mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingGUID)), __LINE__);
        }
        $this->MailingGUID = $mailingGUID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\ProcessMailing
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get PartialProcess value
     * @return bool
     */
    public function getPartialProcess()
    {
        return $this->PartialProcess;
    }
    /**
     * Set PartialProcess value
     * @param bool $partialProcess
     * @return \StructType\ProcessMailing
     */
    public function setPartialProcess($partialProcess = null)
    {
        // validation for constraint: boolean
        if (!is_null($partialProcess) && !is_bool($partialProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($partialProcess)), __LINE__);
        }
        $this->PartialProcess = $partialProcess;
        return $this;
    }
    /**
     * Get MaxPriceExVAT value
     * @return float
     */
    public function getMaxPriceExVAT()
    {
        return $this->MaxPriceExVAT;
    }
    /**
     * Set MaxPriceExVAT value
     * @param float $maxPriceExVAT
     * @return \StructType\ProcessMailing
     */
    public function setMaxPriceExVAT($maxPriceExVAT = null)
    {
        $this->MaxPriceExVAT = $maxPriceExVAT;
        return $this;
    }
    /**
     * Get SkipPreviewImageGeneration value
     * @return bool
     */
    public function getSkipPreviewImageGeneration()
    {
        return $this->SkipPreviewImageGeneration;
    }
    /**
     * Set SkipPreviewImageGeneration value
     * @param bool $skipPreviewImageGeneration
     * @return \StructType\ProcessMailing
     */
    public function setSkipPreviewImageGeneration($skipPreviewImageGeneration = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipPreviewImageGeneration) && !is_bool($skipPreviewImageGeneration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($skipPreviewImageGeneration)), __LINE__);
        }
        $this->SkipPreviewImageGeneration = $skipPreviewImageGeneration;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\ProcessMailing
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\ProcessMailing
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get CustomerApplication value
     * @return string|null
     */
    public function getCustomerApplication()
    {
        return $this->CustomerApplication;
    }
    /**
     * Set CustomerApplication value
     * @param string $customerApplication
     * @return \StructType\ProcessMailing
     */
    public function setCustomerApplication($customerApplication = null)
    {
        // validation for constraint: string
        if (!is_null($customerApplication) && !is_string($customerApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerApplication)), __LINE__);
        }
        $this->CustomerApplication = $customerApplication;
        return $this;
    }
    /**
     * Get POReference value
     * @return string|null
     */
    public function getPOReference()
    {
        return $this->POReference;
    }
    /**
     * Set POReference value
     * @param string $pOReference
     * @return \StructType\ProcessMailing
     */
    public function setPOReference($pOReference = null)
    {
        // validation for constraint: string
        if (!is_null($pOReference) && !is_string($pOReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pOReference)), __LINE__);
        }
        $this->POReference = $pOReference;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param string $paymentMethod
     * @return \StructType\ProcessMailing
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentMethod)), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get EmailSuccessList value
     * @return string|null
     */
    public function getEmailSuccessList()
    {
        return $this->EmailSuccessList;
    }
    /**
     * Set EmailSuccessList value
     * @param string $emailSuccessList
     * @return \StructType\ProcessMailing
     */
    public function setEmailSuccessList($emailSuccessList = null)
    {
        // validation for constraint: string
        if (!is_null($emailSuccessList) && !is_string($emailSuccessList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailSuccessList)), __LINE__);
        }
        $this->EmailSuccessList = $emailSuccessList;
        return $this;
    }
    /**
     * Get EmailErrorList value
     * @return string|null
     */
    public function getEmailErrorList()
    {
        return $this->EmailErrorList;
    }
    /**
     * Set EmailErrorList value
     * @param string $emailErrorList
     * @return \StructType\ProcessMailing
     */
    public function setEmailErrorList($emailErrorList = null)
    {
        // validation for constraint: string
        if (!is_null($emailErrorList) && !is_string($emailErrorList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailErrorList)), __LINE__);
        }
        $this->EmailErrorList = $emailErrorList;
        return $this;
    }
    /**
     * Get HttpPostOnSuccess value
     * @return string|null
     */
    public function getHttpPostOnSuccess()
    {
        return $this->HttpPostOnSuccess;
    }
    /**
     * Set HttpPostOnSuccess value
     * @param string $httpPostOnSuccess
     * @return \StructType\ProcessMailing
     */
    public function setHttpPostOnSuccess($httpPostOnSuccess = null)
    {
        // validation for constraint: string
        if (!is_null($httpPostOnSuccess) && !is_string($httpPostOnSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($httpPostOnSuccess)), __LINE__);
        }
        $this->HttpPostOnSuccess = $httpPostOnSuccess;
        return $this;
    }
    /**
     * Get HttpPostOnError value
     * @return string|null
     */
    public function getHttpPostOnError()
    {
        return $this->HttpPostOnError;
    }
    /**
     * Set HttpPostOnError value
     * @param string $httpPostOnError
     * @return \StructType\ProcessMailing
     */
    public function setHttpPostOnError($httpPostOnError = null)
    {
        // validation for constraint: string
        if (!is_null($httpPostOnError) && !is_string($httpPostOnError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($httpPostOnError)), __LINE__);
        }
        $this->HttpPostOnError = $httpPostOnError;
        return $this;
    }
    /**
     * Get ReturnFormat value
     * @return string|null
     */
    public function getReturnFormat()
    {
        return $this->ReturnFormat;
    }
    /**
     * Set ReturnFormat value
     * @param string $returnFormat
     * @return \StructType\ProcessMailing
     */
    public function setReturnFormat($returnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($returnFormat) && !is_string($returnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFormat)), __LINE__);
        }
        $this->ReturnFormat = $returnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProcessMailing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
