<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListTemplateVariables StructType
 * @subpackage Structs
 */
class ListTemplateVariables extends AbstractStructBase
{
    /**
     * The TemplateGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $TemplateGUID;
    /**
     * The RequiresEntryOnly
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RequiresEntryOnly;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The ListFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ListFormat;
    /**
     * The FailureReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FailureReturnFormat;
    /**
     * Constructor method for ListTemplateVariables
     * @uses ListTemplateVariables::setTemplateGUID()
     * @uses ListTemplateVariables::setRequiresEntryOnly()
     * @uses ListTemplateVariables::setUsername()
     * @uses ListTemplateVariables::setPassword()
     * @uses ListTemplateVariables::setListFormat()
     * @uses ListTemplateVariables::setFailureReturnFormat()
     * @param string $templateGUID
     * @param bool $requiresEntryOnly
     * @param string $username
     * @param string $password
     * @param string $listFormat
     * @param string $failureReturnFormat
     */
    public function __construct($templateGUID = null, $requiresEntryOnly = null, $username = null, $password = null, $listFormat = null, $failureReturnFormat = null)
    {
        $this
            ->setTemplateGUID($templateGUID)
            ->setRequiresEntryOnly($requiresEntryOnly)
            ->setUsername($username)
            ->setPassword($password)
            ->setListFormat($listFormat)
            ->setFailureReturnFormat($failureReturnFormat);
    }
    /**
     * Get TemplateGUID value
     * @return string
     */
    public function getTemplateGUID()
    {
        return $this->TemplateGUID;
    }
    /**
     * Set TemplateGUID value
     * @param string $templateGUID
     * @return \StructType\ListTemplateVariables
     */
    public function setTemplateGUID($templateGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($templateGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $templateGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($templateGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($templateGUID) && !is_string($templateGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($templateGUID)), __LINE__);
        }
        $this->TemplateGUID = $templateGUID;
        return $this;
    }
    /**
     * Get RequiresEntryOnly value
     * @return bool
     */
    public function getRequiresEntryOnly()
    {
        return $this->RequiresEntryOnly;
    }
    /**
     * Set RequiresEntryOnly value
     * @param bool $requiresEntryOnly
     * @return \StructType\ListTemplateVariables
     */
    public function setRequiresEntryOnly($requiresEntryOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiresEntryOnly) && !is_bool($requiresEntryOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requiresEntryOnly)), __LINE__);
        }
        $this->RequiresEntryOnly = $requiresEntryOnly;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\ListTemplateVariables
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\ListTemplateVariables
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get ListFormat value
     * @return string|null
     */
    public function getListFormat()
    {
        return $this->ListFormat;
    }
    /**
     * Set ListFormat value
     * @param string $listFormat
     * @return \StructType\ListTemplateVariables
     */
    public function setListFormat($listFormat = null)
    {
        // validation for constraint: string
        if (!is_null($listFormat) && !is_string($listFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($listFormat)), __LINE__);
        }
        $this->ListFormat = $listFormat;
        return $this;
    }
    /**
     * Get FailureReturnFormat value
     * @return string|null
     */
    public function getFailureReturnFormat()
    {
        return $this->FailureReturnFormat;
    }
    /**
     * Set FailureReturnFormat value
     * @param string $failureReturnFormat
     * @return \StructType\ListTemplateVariables
     */
    public function setFailureReturnFormat($failureReturnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($failureReturnFormat) && !is_string($failureReturnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($failureReturnFormat)), __LINE__);
        }
        $this->FailureReturnFormat = $failureReturnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListTemplateVariables
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
