<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListProductTypes StructType
 * @subpackage Structs
 */
class ListProductTypes extends AbstractStructBase
{
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The ListFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ListFormat;
    /**
     * The FailureReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FailureReturnFormat;
    /**
     * Constructor method for ListProductTypes
     * @uses ListProductTypes::setUsername()
     * @uses ListProductTypes::setPassword()
     * @uses ListProductTypes::setListFormat()
     * @uses ListProductTypes::setFailureReturnFormat()
     * @param string $username
     * @param string $password
     * @param string $listFormat
     * @param string $failureReturnFormat
     */
    public function __construct($username = null, $password = null, $listFormat = null, $failureReturnFormat = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setListFormat($listFormat)
            ->setFailureReturnFormat($failureReturnFormat);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\ListProductTypes
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\ListProductTypes
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get ListFormat value
     * @return string|null
     */
    public function getListFormat()
    {
        return $this->ListFormat;
    }
    /**
     * Set ListFormat value
     * @param string $listFormat
     * @return \StructType\ListProductTypes
     */
    public function setListFormat($listFormat = null)
    {
        // validation for constraint: string
        if (!is_null($listFormat) && !is_string($listFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($listFormat)), __LINE__);
        }
        $this->ListFormat = $listFormat;
        return $this;
    }
    /**
     * Get FailureReturnFormat value
     * @return string|null
     */
    public function getFailureReturnFormat()
    {
        return $this->FailureReturnFormat;
    }
    /**
     * Set FailureReturnFormat value
     * @param string $failureReturnFormat
     * @return \StructType\ListProductTypes
     */
    public function setFailureReturnFormat($failureReturnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($failureReturnFormat) && !is_string($failureReturnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($failureReturnFormat)), __LINE__);
        }
        $this->FailureReturnFormat = $failureReturnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListProductTypes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
