<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListMailings StructType
 * @subpackage Structs
 */
class ListMailings extends AbstractStructBase
{
    /**
     * The SubmittedFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SubmittedFrom;
    /**
     * The SubmittedTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SubmittedTo;
    /**
     * The OutstandingOnly
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OutstandingOnly;
    /**
     * The AllUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllUsers;
    /**
     * The CanContentApproveOnly
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CanContentApproveOnly;
    /**
     * The CanBudgetApproveOnly
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CanBudgetApproveOnly;
    /**
     * The PageSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageSize;
    /**
     * The PageNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageNumber;
    /**
     * The SortDescending
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SortDescending;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The ProductType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductType;
    /**
     * The SearchText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SearchText;
    /**
     * The CustomerApplication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerApplication;
    /**
     * The SortColumn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SortColumn;
    /**
     * The ListFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ListFormat;
    /**
     * The FailureReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FailureReturnFormat;
    /**
     * Constructor method for ListMailings
     * @uses ListMailings::setSubmittedFrom()
     * @uses ListMailings::setSubmittedTo()
     * @uses ListMailings::setOutstandingOnly()
     * @uses ListMailings::setAllUsers()
     * @uses ListMailings::setCanContentApproveOnly()
     * @uses ListMailings::setCanBudgetApproveOnly()
     * @uses ListMailings::setPageSize()
     * @uses ListMailings::setPageNumber()
     * @uses ListMailings::setSortDescending()
     * @uses ListMailings::setUsername()
     * @uses ListMailings::setPassword()
     * @uses ListMailings::setProductType()
     * @uses ListMailings::setSearchText()
     * @uses ListMailings::setCustomerApplication()
     * @uses ListMailings::setSortColumn()
     * @uses ListMailings::setListFormat()
     * @uses ListMailings::setFailureReturnFormat()
     * @param string $submittedFrom
     * @param string $submittedTo
     * @param bool $outstandingOnly
     * @param bool $allUsers
     * @param bool $canContentApproveOnly
     * @param bool $canBudgetApproveOnly
     * @param int $pageSize
     * @param int $pageNumber
     * @param bool $sortDescending
     * @param string $username
     * @param string $password
     * @param string $productType
     * @param string $searchText
     * @param string $customerApplication
     * @param string $sortColumn
     * @param string $listFormat
     * @param string $failureReturnFormat
     */
    public function __construct($submittedFrom = null, $submittedTo = null, $outstandingOnly = null, $allUsers = null, $canContentApproveOnly = null, $canBudgetApproveOnly = null, $pageSize = null, $pageNumber = null, $sortDescending = null, $username = null, $password = null, $productType = null, $searchText = null, $customerApplication = null, $sortColumn = null, $listFormat = null, $failureReturnFormat = null)
    {
        $this
            ->setSubmittedFrom($submittedFrom)
            ->setSubmittedTo($submittedTo)
            ->setOutstandingOnly($outstandingOnly)
            ->setAllUsers($allUsers)
            ->setCanContentApproveOnly($canContentApproveOnly)
            ->setCanBudgetApproveOnly($canBudgetApproveOnly)
            ->setPageSize($pageSize)
            ->setPageNumber($pageNumber)
            ->setSortDescending($sortDescending)
            ->setUsername($username)
            ->setPassword($password)
            ->setProductType($productType)
            ->setSearchText($searchText)
            ->setCustomerApplication($customerApplication)
            ->setSortColumn($sortColumn)
            ->setListFormat($listFormat)
            ->setFailureReturnFormat($failureReturnFormat);
    }
    /**
     * Get SubmittedFrom value
     * @return string
     */
    public function getSubmittedFrom()
    {
        return $this->SubmittedFrom;
    }
    /**
     * Set SubmittedFrom value
     * @param string $submittedFrom
     * @return \StructType\ListMailings
     */
    public function setSubmittedFrom($submittedFrom = null)
    {
        // validation for constraint: string
        if (!is_null($submittedFrom) && !is_string($submittedFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submittedFrom)), __LINE__);
        }
        $this->SubmittedFrom = $submittedFrom;
        return $this;
    }
    /**
     * Get SubmittedTo value
     * @return string
     */
    public function getSubmittedTo()
    {
        return $this->SubmittedTo;
    }
    /**
     * Set SubmittedTo value
     * @param string $submittedTo
     * @return \StructType\ListMailings
     */
    public function setSubmittedTo($submittedTo = null)
    {
        // validation for constraint: string
        if (!is_null($submittedTo) && !is_string($submittedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submittedTo)), __LINE__);
        }
        $this->SubmittedTo = $submittedTo;
        return $this;
    }
    /**
     * Get OutstandingOnly value
     * @return bool
     */
    public function getOutstandingOnly()
    {
        return $this->OutstandingOnly;
    }
    /**
     * Set OutstandingOnly value
     * @param bool $outstandingOnly
     * @return \StructType\ListMailings
     */
    public function setOutstandingOnly($outstandingOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($outstandingOnly) && !is_bool($outstandingOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($outstandingOnly)), __LINE__);
        }
        $this->OutstandingOnly = $outstandingOnly;
        return $this;
    }
    /**
     * Get AllUsers value
     * @return bool
     */
    public function getAllUsers()
    {
        return $this->AllUsers;
    }
    /**
     * Set AllUsers value
     * @param bool $allUsers
     * @return \StructType\ListMailings
     */
    public function setAllUsers($allUsers = null)
    {
        // validation for constraint: boolean
        if (!is_null($allUsers) && !is_bool($allUsers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allUsers)), __LINE__);
        }
        $this->AllUsers = $allUsers;
        return $this;
    }
    /**
     * Get CanContentApproveOnly value
     * @return bool
     */
    public function getCanContentApproveOnly()
    {
        return $this->CanContentApproveOnly;
    }
    /**
     * Set CanContentApproveOnly value
     * @param bool $canContentApproveOnly
     * @return \StructType\ListMailings
     */
    public function setCanContentApproveOnly($canContentApproveOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($canContentApproveOnly) && !is_bool($canContentApproveOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($canContentApproveOnly)), __LINE__);
        }
        $this->CanContentApproveOnly = $canContentApproveOnly;
        return $this;
    }
    /**
     * Get CanBudgetApproveOnly value
     * @return bool
     */
    public function getCanBudgetApproveOnly()
    {
        return $this->CanBudgetApproveOnly;
    }
    /**
     * Set CanBudgetApproveOnly value
     * @param bool $canBudgetApproveOnly
     * @return \StructType\ListMailings
     */
    public function setCanBudgetApproveOnly($canBudgetApproveOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($canBudgetApproveOnly) && !is_bool($canBudgetApproveOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($canBudgetApproveOnly)), __LINE__);
        }
        $this->CanBudgetApproveOnly = $canBudgetApproveOnly;
        return $this;
    }
    /**
     * Get PageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param int $pageSize
     * @return \StructType\ListMailings
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !is_numeric($pageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Get PageNumber value
     * @return int
     */
    public function getPageNumber()
    {
        return $this->PageNumber;
    }
    /**
     * Set PageNumber value
     * @param int $pageNumber
     * @return \StructType\ListMailings
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pageNumber) && !is_numeric($pageNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageNumber)), __LINE__);
        }
        $this->PageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get SortDescending value
     * @return bool
     */
    public function getSortDescending()
    {
        return $this->SortDescending;
    }
    /**
     * Set SortDescending value
     * @param bool $sortDescending
     * @return \StructType\ListMailings
     */
    public function setSortDescending($sortDescending = null)
    {
        // validation for constraint: boolean
        if (!is_null($sortDescending) && !is_bool($sortDescending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sortDescending)), __LINE__);
        }
        $this->SortDescending = $sortDescending;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\ListMailings
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\ListMailings
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param string $productType
     * @return \StructType\ListMailings
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productType)), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get SearchText value
     * @return string|null
     */
    public function getSearchText()
    {
        return $this->SearchText;
    }
    /**
     * Set SearchText value
     * @param string $searchText
     * @return \StructType\ListMailings
     */
    public function setSearchText($searchText = null)
    {
        // validation for constraint: string
        if (!is_null($searchText) && !is_string($searchText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchText)), __LINE__);
        }
        $this->SearchText = $searchText;
        return $this;
    }
    /**
     * Get CustomerApplication value
     * @return string|null
     */
    public function getCustomerApplication()
    {
        return $this->CustomerApplication;
    }
    /**
     * Set CustomerApplication value
     * @param string $customerApplication
     * @return \StructType\ListMailings
     */
    public function setCustomerApplication($customerApplication = null)
    {
        // validation for constraint: string
        if (!is_null($customerApplication) && !is_string($customerApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerApplication)), __LINE__);
        }
        $this->CustomerApplication = $customerApplication;
        return $this;
    }
    /**
     * Get SortColumn value
     * @return string|null
     */
    public function getSortColumn()
    {
        return $this->SortColumn;
    }
    /**
     * Set SortColumn value
     * @param string $sortColumn
     * @return \StructType\ListMailings
     */
    public function setSortColumn($sortColumn = null)
    {
        // validation for constraint: string
        if (!is_null($sortColumn) && !is_string($sortColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sortColumn)), __LINE__);
        }
        $this->SortColumn = $sortColumn;
        return $this;
    }
    /**
     * Get ListFormat value
     * @return string|null
     */
    public function getListFormat()
    {
        return $this->ListFormat;
    }
    /**
     * Set ListFormat value
     * @param string $listFormat
     * @return \StructType\ListMailings
     */
    public function setListFormat($listFormat = null)
    {
        // validation for constraint: string
        if (!is_null($listFormat) && !is_string($listFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($listFormat)), __LINE__);
        }
        $this->ListFormat = $listFormat;
        return $this;
    }
    /**
     * Get FailureReturnFormat value
     * @return string|null
     */
    public function getFailureReturnFormat()
    {
        return $this->FailureReturnFormat;
    }
    /**
     * Set FailureReturnFormat value
     * @param string $failureReturnFormat
     * @return \StructType\ListMailings
     */
    public function setFailureReturnFormat($failureReturnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($failureReturnFormat) && !is_string($failureReturnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($failureReturnFormat)), __LINE__);
        }
        $this->FailureReturnFormat = $failureReturnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListMailings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
