<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListMailingVariableValues StructType
 * @subpackage Structs
 */
class ListMailingVariableValues extends AbstractStructBase
{
    /**
     * The MailingGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $MailingGUID;
    /**
     * The TemplateGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $TemplateGUID;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The VariableName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VariableName;
    /**
     * The ListFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ListFormat;
    /**
     * The FailureReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FailureReturnFormat;
    /**
     * Constructor method for ListMailingVariableValues
     * @uses ListMailingVariableValues::setMailingGUID()
     * @uses ListMailingVariableValues::setTemplateGUID()
     * @uses ListMailingVariableValues::setUsername()
     * @uses ListMailingVariableValues::setPassword()
     * @uses ListMailingVariableValues::setVariableName()
     * @uses ListMailingVariableValues::setListFormat()
     * @uses ListMailingVariableValues::setFailureReturnFormat()
     * @param string $mailingGUID
     * @param string $templateGUID
     * @param string $username
     * @param string $password
     * @param string $variableName
     * @param string $listFormat
     * @param string $failureReturnFormat
     */
    public function __construct($mailingGUID = null, $templateGUID = null, $username = null, $password = null, $variableName = null, $listFormat = null, $failureReturnFormat = null)
    {
        $this
            ->setMailingGUID($mailingGUID)
            ->setTemplateGUID($templateGUID)
            ->setUsername($username)
            ->setPassword($password)
            ->setVariableName($variableName)
            ->setListFormat($listFormat)
            ->setFailureReturnFormat($failureReturnFormat);
    }
    /**
     * Get MailingGUID value
     * @return string
     */
    public function getMailingGUID()
    {
        return $this->MailingGUID;
    }
    /**
     * Set MailingGUID value
     * @param string $mailingGUID
     * @return \StructType\ListMailingVariableValues
     */
    public function setMailingGUID($mailingGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mailingGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($mailingGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mailingGUID) && !is_string($mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingGUID)), __LINE__);
        }
        $this->MailingGUID = $mailingGUID;
        return $this;
    }
    /**
     * Get TemplateGUID value
     * @return string
     */
    public function getTemplateGUID()
    {
        return $this->TemplateGUID;
    }
    /**
     * Set TemplateGUID value
     * @param string $templateGUID
     * @return \StructType\ListMailingVariableValues
     */
    public function setTemplateGUID($templateGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($templateGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $templateGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($templateGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($templateGUID) && !is_string($templateGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($templateGUID)), __LINE__);
        }
        $this->TemplateGUID = $templateGUID;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\ListMailingVariableValues
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\ListMailingVariableValues
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get VariableName value
     * @return string|null
     */
    public function getVariableName()
    {
        return $this->VariableName;
    }
    /**
     * Set VariableName value
     * @param string $variableName
     * @return \StructType\ListMailingVariableValues
     */
    public function setVariableName($variableName = null)
    {
        // validation for constraint: string
        if (!is_null($variableName) && !is_string($variableName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($variableName)), __LINE__);
        }
        $this->VariableName = $variableName;
        return $this;
    }
    /**
     * Get ListFormat value
     * @return string|null
     */
    public function getListFormat()
    {
        return $this->ListFormat;
    }
    /**
     * Set ListFormat value
     * @param string $listFormat
     * @return \StructType\ListMailingVariableValues
     */
    public function setListFormat($listFormat = null)
    {
        // validation for constraint: string
        if (!is_null($listFormat) && !is_string($listFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($listFormat)), __LINE__);
        }
        $this->ListFormat = $listFormat;
        return $this;
    }
    /**
     * Get FailureReturnFormat value
     * @return string|null
     */
    public function getFailureReturnFormat()
    {
        return $this->FailureReturnFormat;
    }
    /**
     * Set FailureReturnFormat value
     * @param string $failureReturnFormat
     * @return \StructType\ListMailingVariableValues
     */
    public function setFailureReturnFormat($failureReturnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($failureReturnFormat) && !is_string($failureReturnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($failureReturnFormat)), __LINE__);
        }
        $this->FailureReturnFormat = $failureReturnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListMailingVariableValues
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
