<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListMailingFiltersForCategory StructType
 * @subpackage Structs
 */
class ListMailingFiltersForCategory extends AbstractStructBase
{
    /**
     * The MailingGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $MailingGUID;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The CategoryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryName;
    /**
     * The ListFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ListFormat;
    /**
     * The FailureReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FailureReturnFormat;
    /**
     * Constructor method for ListMailingFiltersForCategory
     * @uses ListMailingFiltersForCategory::setMailingGUID()
     * @uses ListMailingFiltersForCategory::setUsername()
     * @uses ListMailingFiltersForCategory::setPassword()
     * @uses ListMailingFiltersForCategory::setCategoryName()
     * @uses ListMailingFiltersForCategory::setListFormat()
     * @uses ListMailingFiltersForCategory::setFailureReturnFormat()
     * @param string $mailingGUID
     * @param string $username
     * @param string $password
     * @param string $categoryName
     * @param string $listFormat
     * @param string $failureReturnFormat
     */
    public function __construct($mailingGUID = null, $username = null, $password = null, $categoryName = null, $listFormat = null, $failureReturnFormat = null)
    {
        $this
            ->setMailingGUID($mailingGUID)
            ->setUsername($username)
            ->setPassword($password)
            ->setCategoryName($categoryName)
            ->setListFormat($listFormat)
            ->setFailureReturnFormat($failureReturnFormat);
    }
    /**
     * Get MailingGUID value
     * @return string
     */
    public function getMailingGUID()
    {
        return $this->MailingGUID;
    }
    /**
     * Set MailingGUID value
     * @param string $mailingGUID
     * @return \StructType\ListMailingFiltersForCategory
     */
    public function setMailingGUID($mailingGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mailingGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($mailingGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mailingGUID) && !is_string($mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingGUID)), __LINE__);
        }
        $this->MailingGUID = $mailingGUID;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\ListMailingFiltersForCategory
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\ListMailingFiltersForCategory
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get CategoryName value
     * @return string|null
     */
    public function getCategoryName()
    {
        return $this->CategoryName;
    }
    /**
     * Set CategoryName value
     * @param string $categoryName
     * @return \StructType\ListMailingFiltersForCategory
     */
    public function setCategoryName($categoryName = null)
    {
        // validation for constraint: string
        if (!is_null($categoryName) && !is_string($categoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryName)), __LINE__);
        }
        $this->CategoryName = $categoryName;
        return $this;
    }
    /**
     * Get ListFormat value
     * @return string|null
     */
    public function getListFormat()
    {
        return $this->ListFormat;
    }
    /**
     * Set ListFormat value
     * @param string $listFormat
     * @return \StructType\ListMailingFiltersForCategory
     */
    public function setListFormat($listFormat = null)
    {
        // validation for constraint: string
        if (!is_null($listFormat) && !is_string($listFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($listFormat)), __LINE__);
        }
        $this->ListFormat = $listFormat;
        return $this;
    }
    /**
     * Get FailureReturnFormat value
     * @return string|null
     */
    public function getFailureReturnFormat()
    {
        return $this->FailureReturnFormat;
    }
    /**
     * Set FailureReturnFormat value
     * @param string $failureReturnFormat
     * @return \StructType\ListMailingFiltersForCategory
     */
    public function setFailureReturnFormat($failureReturnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($failureReturnFormat) && !is_string($failureReturnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($failureReturnFormat)), __LINE__);
        }
        $this->FailureReturnFormat = $failureReturnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListMailingFiltersForCategory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
