<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBalance StructType
 * @subpackage Structs
 */
class GetBalance extends AbstractStructBase
{
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The AccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountType;
    /**
     * The ReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFormat;
    /**
     * Constructor method for GetBalance
     * @uses GetBalance::setUsername()
     * @uses GetBalance::setPassword()
     * @uses GetBalance::setAccountType()
     * @uses GetBalance::setReturnFormat()
     * @param string $username
     * @param string $password
     * @param string $accountType
     * @param string $returnFormat
     */
    public function __construct($username = null, $password = null, $accountType = null, $returnFormat = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setAccountType($accountType)
            ->setReturnFormat($returnFormat);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\GetBalance
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\GetBalance
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get AccountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->AccountType;
    }
    /**
     * Set AccountType value
     * @param string $accountType
     * @return \StructType\GetBalance
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: string
        if (!is_null($accountType) && !is_string($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountType)), __LINE__);
        }
        $this->AccountType = $accountType;
        return $this;
    }
    /**
     * Get ReturnFormat value
     * @return string|null
     */
    public function getReturnFormat()
    {
        return $this->ReturnFormat;
    }
    /**
     * Set ReturnFormat value
     * @param string $returnFormat
     * @return \StructType\GetBalance
     */
    public function setReturnFormat($returnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($returnFormat) && !is_string($returnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFormat)), __LINE__);
        }
        $this->ReturnFormat = $returnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetBalance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
